/*
  Antenna House PDF Tool API V5.0
  Java Interface sample program

  概要：各種座標系オプションを切り替えて、文字列の表示が変化するようにします。

  Copyright (C) 2018- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import java.io.*;
import jp.co.antenna.ptl.*;


public class  ShowCoordinateChange{
    // そのクラスのusageを表示する関数
    private static void printUsage() {
        System.out.println("usage: java ShowCoordinateChange input-pdf-file out-pdf-file" +
                         " 座標系の種類");
        System.out.println("座標系の種類 : ");
        System.out.println("0: 表示上の座標(デフォルト値)　" +
                           "1: PDFユーザースペース座標(ページに合わせて座標が回転する)");
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 3) {
            printUsage();
            return;
        }

        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument();
             PtlOption coordOption = new PtlOption()) {
            // PDFファイルをロードします。
            doc.load(inputFile);

            //コマンドライン引数の読み取り
            int coordType = Integer.parseInt(args[2]);
            // 座標系の種類と例外処理
            switch(coordType) {
            case 0: //表示上の座標(デフォルト値)
                coordOption.setCood(PtlOption.COOD.COOD_VIEW);
                break;
            case 1: // PDFユーザースペース座標
                coordOption.setCood(PtlOption.COOD.COOD_USER);
                break;
            default:
                System.out.println("座標系の種類 は0か1で指定して下さい。");
                printUsage();
                return;
            }

            try (PtlPages pages = doc.getPages()) {//ページコンテナの取得
                // ページコンテナが空かどうか
                if (pages.isEmpty()) {
                    System.err.println("ページコンテナが空");
                    return;
                }
                
                // ページの取得(パラメータindexは0が先頭のため1を引く)
                // ページコンテントの取得
                // 出力矩形の設定 左上が(50,50)になるよう初期化
                // 文字描画のパラメータクラス。今回は何も設定しない。
                try (PtlPage page = pages.get(0);
                     PtlContent content = page.getContent();
                     PtlRect outputRect = setRectTopLeft5050();
                     PtlParamWriteString plainParam = new PtlParamWriteString()) {
                    //回転角を90度に設定
                    page.setRotate(90);
                    // 文字列出力
                    content.writeString(outputRect, PtlContent.ALIGN.ALIGN_TOP_LEFT,
                                        "この文章の左上が現在の座標系の(50,50)です。",
                                        plainParam);
                }

            }

            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                               "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }

    public static PtlRect setRectTopLeft5050()
        throws PtlException, Exception, Error{
        PtlRect outputRect = new PtlRect();
        outputRect.setLeft(50);
        outputRect.setBottom(0);
        outputRect.setRight(100);
        outputRect.setTop(50);

        return outputRect;
    }
}
