﻿/*
  Antenna House PDF Tool API V7.0
  .Net Interface sample program

  概要：作成日時・更新日時の有効性を確認しながら取得します。

  Copyright (C) 2023- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

using PdfTkNet;
using System;

namespace GetDocInfoWithValidationDate
{
    internal class GetDocInfoWithValidationDate
    {
        // そのクラスのusageを表示する関数
        private static void printUsage()
        {
            Console.WriteLine("usage: GetDocInfoWithValidationDate in-pdf-file");
        }

        static void Main(string[] args)
        {
            if (args.Length < 1)
            {
                printUsage();
                return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロード
                    doc.load(inputFile);

                    using (PtlDocProperty docProperty = doc.getDocProperty()) //PDFの文書プロパティ
                    using (PtlDocInfo docinf = docProperty.getDocInfo())
                    {    //PDFの文書情報
                         // 作成日付を取得
                        using (PtlDate dateCreate = docinf.getCreationDate())
                        {
                            if (dateCreate.isValid())
                            { //CreationDateの有効性チェック
                                Console.WriteLine("CreationDate : "
                                    + dateCreate.getYear()
                                    + "/" + dateCreate.getMonth()
                                    + "/" + dateCreate.getDay()
                                    + " " + dateCreate.getHour()
                                    + ":" + dateCreate.getMin()
                                    + ":" + dateCreate.getSec());
                            }
                            else
                            {
                                Console.WriteLine("このPDFは有効なCreationDateを持っていません");
                            }
                        }

                        // 更新日付を取得
                        using (PtlDate dateMod = docinf.getModDate())
                        {
                            if (dateMod.isValid())
                            {
                                Console.WriteLine("ModDate : "
                                    + dateMod.getYear()
                                    + "/" + dateMod.getMonth()
                                    + "/" + dateMod.getDay()
                                    + " " + dateMod.getHour()
                                    + ":" + dateMod.getMin()
                                    + ":" + dateMod.getSec());
                            }
                            else
                            {
                                Console.WriteLine("このPDFは有効なModDateを持っていません。");
                            }
                        }
                    }
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
