﻿/*
  Antenna House PDF Tool API V7.0
  .Net Interface sample program

  概要：PDF/Aの種類を得る

  Copyright (C) 2023- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

using PdfTkNet;
using System;

namespace GetPDFAType
{
    internal class GetPDFAType
    {
        // そのクラスのusageを表示する関数
        public static void printUsage()
        {
            Console.WriteLine("usage: GetPDFAType in-pdf-file");
        }

        static void Main(string[] args)
        {
            if (args.Length < 1)
            {
                printUsage(); // usageメッセージの表示
                return;
            }

            // コマンドライン引数の取得
            try{
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロード
                    doc.load(inputFile);

                    // PDFファイルの種類を判定する
                    if (doc.isPDFA())
                    {
                        Console.Write("この文書は");
                        switch (doc.getPDFAType())
                        {
                            case PtlPDFDocument.PDFA_TYPE.PDFA_1A:
                                Console.WriteLine("PDF/A-1aです。");
                                break;
                            case PtlPDFDocument.PDFA_TYPE.PDFA_1B:
                                Console.WriteLine("PDF/A-1bです。");
                                break;
                            case PtlPDFDocument.PDFA_TYPE.PDFA_2A:
                                Console.WriteLine("PDF/A-2aです。");
                                break;
                            case PtlPDFDocument.PDFA_TYPE.PDFA_2B:
                                Console.WriteLine("PDF/A-2bです。");
                                break;
                            case PtlPDFDocument.PDFA_TYPE.PDFA_2U:
                                Console.WriteLine("PDF/A-2uです。");
                                break;
                            case PtlPDFDocument.PDFA_TYPE.PDFA_3A:
                                Console.WriteLine("PDF/A-3aです。");
                                break;
                            case PtlPDFDocument.PDFA_TYPE.PDFA_3B:
                                Console.WriteLine("PDF/A-3bです。");
                                break;
                            case PtlPDFDocument.PDFA_TYPE.PDFA_3U:
                                Console.WriteLine("PDF/A-3uです。");
                                break;
                            case PtlPDFDocument.PDFA_TYPE.PDFA_UNKNOWN:
                                Console.WriteLine("不明なタイプのPDF/Aです。");
                                break;
                        }
                    }
                    else
                    {
                        Console.WriteLine("この文書はPDF/Aではありません。");
                    }
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
