﻿/*
  Antenna House PDF Tool API V7.0
  .Net Interface sample program

  概要：PDFバージョンの取得

  Copyright (C) 2023- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

using PdfTkNet;
using System;

namespace GetPDFVersion
{
    internal class GetPDFVersion
    {
        // そのクラスのusageを表示する関数
        private static void printUsage()
        {
            Console.WriteLine("usage: GetPDFVersion in-pdf-file");
        }
        static void Main(string[] args)
        {
            if (args.Length < 1)
            {
                printUsage();
                return;
            }

            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロード
                    doc.load(inputFile);

                    using (PtlDocProperty docProperty = doc.getDocProperty())
                    {//PDFの文書プロパティ

                        PtlDocProperty.PDF_VERSION versionOfPDF = docProperty.getVersion();
                        Console.Write("このPDFのバージョンは『");
                        switch (versionOfPDF)
                        {
                            case PtlDocProperty.PDF_VERSION.PDFV1_0:
                                Console.Write(" PDF-1.0 ");
                                break;
                            case PtlDocProperty.PDF_VERSION.PDFV1_1:
                                Console.Write(" PDF-1.1 ");
                                break;
                            case PtlDocProperty.PDF_VERSION.PDFV1_2:
                                Console.Write(" PDF-1.2 ");
                                break;
                            case PtlDocProperty.PDF_VERSION.PDFV1_3:
                                Console.Write(" PDF-1.3 ");
                                break;
                            case PtlDocProperty.PDF_VERSION.PDFV1_4:
                                Console.Write(" PDF-1.4 ");
                                break;
                            case PtlDocProperty.PDF_VERSION.PDFV1_5:
                                Console.Write(" PDF-1.5 ");
                                break;
                            case PtlDocProperty.PDF_VERSION.PDFV1_6:
                                Console.Write(" PDF-1.6 ");
                                break;
                            case PtlDocProperty.PDF_VERSION.PDFV1_7:
                                Console.Write(" PDF-1.7 ");
                                break;
                            case PtlDocProperty.PDF_VERSION.PDFV2_0:
                                Console.Write(" PDF-2.0 ");
                                break;
                        }
                        Console.WriteLine("』です");
                    }
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
