﻿/*
  Antenna House PDF Tool API V7.0
  .Net Interface sample program

  概要：文書情報の設定（日付情報の）

  Copyright (C) 2023- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

using PdfTkNet;
using System;
using System.IO;

namespace SetDocInfoWithValidationDate
{
    internal class SetDocInfoWithValidationDate
    {
        // そのクラスのusageを表示する関数
        private static void printUsage()
        {
            Console.WriteLine("usage: SetDocInfo in-pdf-file out-pdf-file タイトル 作者 ");
        }

        static void Main(string[] args)
        {
            if (args.Length < 4)
            {
                printUsage();
                return;
            }

            String title = args[2];
            String author = args[3];
            try
            {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlParamOutput outputFile = new PtlParamOutput(args[1]))
                using (PtlPDFDocument doc = new PtlPDFDocument())
                {
                    // PDFファイルをロード
                    doc.load(inputFile);

                    using (PtlDocProperty docProperty = doc.getDocProperty()) // PDFの文書プロパティ
                    using (PtlDocInfo docinf = docProperty.getDocInfo())
                    using (PtlDate creationDate = new PtlDate())
                    {
                        // タイトルを設定
                        docinf.setTitle(title);
                        // 著者を設定
                        docinf.setAuthor(author);

                        // 作成日付を設定
                        Console.WriteLine("作成日付を入力してください。");
                        docinf.setCreationDate(setDate(creationDate));

                        // 更新日付を設定(更新時の時間で作成)
                        DateTime timeNow = DateTime.Now;
                        //LocalDateTime timeNow = LocalDateTime.now();
                        using (PtlDate dateModNew = new PtlDate(timeNow.Year,
                                                              timeNow.Month,
                                                              timeNow.Day,
                                                              timeNow.Hour,
                                                              timeNow.Minute,
                                                              timeNow.Second))
                        {
                            docinf.setModDate(dateModNew);
                        }
                    }
                    // ファイルに保存します
                    doc.save(outputFile);
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }

        public static PtlDate setDate(PtlDate date)
        {
            try
            {
                int year;
                int month;
                int day;
                int hour;
                int minute;
                int second;
                bool isValueOkay = false;

                while (!isValueOkay)
                {
                    Console.Write("year : ");
                    year = int.Parse(Console.ReadLine());
                    Console.Write("month : ");
                    month = int.Parse(Console.ReadLine());
                    Console.Write("day : ");
                    day = int.Parse(Console.ReadLine());
                    Console.Write("hour : ");
                    hour = int.Parse(Console.ReadLine());
                    Console.Write("minute : ");
                    minute = int.Parse(Console.ReadLine());
                    Console.Write("second : ");
                    second = int.Parse(Console.ReadLine());

                    date.setYear(year);
                    date.setMonth(month);
                    date.setDay(day);
                    date.setHour(hour);
                    date.setMin(minute);
                    date.setSec(second);

                    //PtlDateの数値が正しいかどうかを判定する。
                    if (date.isValid())
                    {
                        isValueOkay = true;
                    }
                    else
                    {
                        Console.WriteLine("PtlDateとして保持できない数値が入力されています。");
                        Console.WriteLine("もう一度入力して下さい。");
                    }
                }
                return date;
            }
            catch (IOException ex)
            {
                throw ex;
            }
            catch (PtlException ex)
            {
                throw ex;
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }
    }
}
