﻿/*
  Antenna House PDF Tool API V7.0
  .Net Interface sample program

  概要：PDFAであることを確認する

  Copyright (C) 2023- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

using PdfTkNet;
using System;

namespace ValidatePDFA
{
    internal class ValidatePDFA
    {
        // そのクラスのusageを表示する関数
        public static void printUsage()
        {
            Console.WriteLine("usage: ValidatePDFA in-pdf-file");
        }

        static void Main(string[] args)
        {
            if (args.Length < 1)
            {
                printUsage(); // usageメッセージの表示
                return;
            }

            // コマンドライン引数の取得
            try {
                using (PtlParamInput inputFile = new PtlParamInput(args[0]))
                using (PtlPDFFixUp fixUp = new PtlPDFFixUp())
                {
                    // PDFファイルを読み込んで鑑定する
                    //PDF/A-1bであるかを判定する
                    if (fixUp.validatePDFA(PtlPDFFixUp.PDFA_TYPE.PDFA_1B, inputFile))
                    {
                        Console.WriteLine("このPDFはPDF/A-1bに準拠しています");
                    }
                    else if (fixUp.validatePDFA(PtlPDFFixUp.PDFA_TYPE.PDFA_2B, inputFile))
                    {
                        Console.WriteLine("このPDFはPDF/A-2bに準拠しています");
                    }
                    else
                    {
                        Console.WriteLine("このPDFはPDF/A-1b、PDF/A-2bのどちらにも準拠していません。");
                        using (PtlPDFFixUpErrors fixUpErrors = fixUp.getErrors())
                        {
                            int numErrors = fixUpErrors.getCount();
                            for (int i = 0; i < numErrors; i++)
                            {
                                using (PtlPDFFixUpError thisFixUpError = fixUpErrors.get(i))
                                {
                                    Console.WriteLine("エラーその" + i + "：" + thisFixUpError.getErrorMessageJP());
                                }
                            }
                        }
                    }
                }
            }
            catch (PtlException pex)
            {
                Console.WriteLine("PtlException : ErrorCode = " + pex.getErrorCode() + "\n  " + pex.getErrorMessage());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.StackTrace);
            }
            finally
            {
                Console.WriteLine("-- 完了 --");
            }
        }
    }
}
