/*
  Antenna House PDF Tool API V7.0
  Java Interface sample program

  概要：文字列の色を設定して１ページ目中央に描画するプログラム。
        このプログラムではセパレーション色[Separation]を用いて色を指定する。

  Copyright (C) 2023- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class AddTextSetSeparationColor {
    // そのクラスのusageを表示する関数
    private static void printUsage() {
        System.out.println("usage: java AddTextSetSeparationColor in-pdf-file out-pdf-file"
                         + " color-name value-c value-m value-y value-k tint");
     }
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 8) {
            printUsage();
            return;
        }

        String colName = args[2];
        float valueC = Float.parseFloat(args[3]);
        float valueM = Float.parseFloat(args[4]);
        float valueY = Float.parseFloat(args[5]);
        float valueK = Float.parseFloat(args[6]);
        float tint = Float.parseFloat(args[7]);
        
        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロードします。
            doc.load(inputFile);

            try (PtlPages pages = doc.getPages()) {//ページコンテナの取得
                // ページコンテナが空かどうか
                if (pages.isEmpty()) {
                    System.err.println("ページコンテナが空");
                    return;
                }
                
                try (PtlPage page = pages.get(0); // ページの取得(先頭ページを取得)
                     PtlContent content = page.getContent(); // ページコンテントの取得
                     PtlRect outputRect = page.getViewBox(); // 出力矩形の設定。(ページの大きさを得るためにViewBoxを取得する)
                     PtlParamFont font = new PtlParamFont("ＭＳ ゴシック", 36, true, false, true); // 出力テキストのフォント
                     PtlParamWriteString writeStringParam = new PtlParamWriteString(); // 文字描画のパラメータクラス
                     // 色表現用のクラスを作成
                     PtlColorSpaceSeparation colorSpace = new PtlColorSpaceSeparation(colName, 
                                                                                    valueC, valueM,valueY,valueK);
                     PtlColorSeparation colSeparation = new PtlColorSeparation(colorSpace , tint)) {// セパレーション色を表現したクラス
                    //文字の色指定
                    writeStringParam.setTextColor(colSeparation);
                    
                    //フォントの指定（文字色を確認しやすくするため大きく描画する）
                    writeStringParam.setFont(font);
                    // 文字列出力 (中央に文字列を作成)
                    content.writeString(outputRect, PtlContent.ALIGN.ALIGN_CENTER,
                                        "writeString Test : set color", writeStringParam);
                }
            }

            // ファイルに保存します。
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                               "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}