/*
  Antenna House PDF Tool API V7.0
  Java Interface sample program

  概要：PDF/Aの種類を得る

  Copyright (C) 2023- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class GetPDFAType {

    // そのクラスのusageを表示する関数
    public static void printUsage() {
        System.out.println("usage: java GetPDFAType in-pdf-file");
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            printUsage(); // usageメッセージの表示
            return;
        }

        // コマンドライン引数の取得
        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロード
            doc.load(inputFile);

            // PDFファイルの種類を判定する
            if(doc.isPDFA()){
                System.out.print("この文書は");
                switch (doc.getPDFAType()) {
                case PDFA_1A:
                    System.out.println("PDF/A-1aです。");
                    break;
                case PDFA_1B:
                    System.out.println("PDF/A-1bです。");
                    break;
                case PDFA_2A:
                    System.out.println("PDF/A-2aです。");
                    break;
                case PDFA_2B:
                    System.out.println("PDF/A-2bです。");
                    break;
                case PDFA_2U:
                    System.out.println("PDF/A-2uです。");
                    break;
                case PDFA_3A:
                    System.out.println("PDF/A-3aです。");
                    break;
                case PDFA_3B:
                    System.out.println("PDF/A-3bです。");
                    break;
                case PDFA_3U:
                    System.out.println("PDF/A-3uです。");
                    break;
                case PDFA_UNKNOWN:
                    System.out.println("不明なタイプのPDF/Aです。");
                    break;
                }
            }else{
                System.out.println("この文書はPDF/Aではありません。");
            }
            
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                               "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}