/*
  Antenna House PDF Tool API V7.0
  Java Interface sample program

  概要：PDFバージョンの取得

  Copyright (C) 2023- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class GetPDFVersion {

    // そのクラスのusageを表示する関数
    private static void printUsage() {
        System.out.println("usage: java GetPDFVersion in-pdf-file");
     }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            printUsage();
            return;
        }

        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロード
            doc.load(inputFile);

            try (PtlDocProperty docProperty = doc.getDocProperty()) {//PDFの文書プロパティ
            
                PtlDocProperty.PDF_VERSION versionOfPDF = docProperty.getVersion();
                System.out.print("このPDFのバージョンは『");
                switch (versionOfPDF) {
                case PDFV1_0:
                    System.out.print(" PDF-1.0 " );
                    break;
                case PDFV1_1:
                    System.out.print(" PDF-1.1 " );
                    break;
                case PDFV1_2:
                    System.out.print(" PDF-1.2 " );
                    break;
                case PDFV1_3:
                    System.out.print(" PDF-1.3 " );
                    break;
                case PDFV1_4:
                    System.out.print(" PDF-1.4 " );
                    break;
                case PDFV1_5:
                    System.out.print(" PDF-1.5 " );
                    break;
                case PDFV1_6:
                    System.out.print(" PDF-1.6 " );
                    break;
                case PDFV1_7:
                    System.out.print(" PDF-1.7 " );
                    break;
                case PDFV2_0:
                    System.out.print(" PDF-2.0 " );
                    break;
                }
                System.out.println("』です");

            }
            
            
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                               "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}