/*
  Antenna House PDF Tool API V7.0
  Java Interface sample program

  概要：文書情報の設定（日付情報の）

  Copyright (C) 2023- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import jp.co.antenna.ptl.*;
import java.time.LocalDateTime;
public class SetDocInfoWithValidationDate {
    // そのクラスのusageを表示する関数
    private static void printUsage() {
        System.out.println("usage: java SetDocInfo in-pdf-file out-pdf-file" +
                           " タイトル 作者 ");
     }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 4) {
            printUsage();
            return;
        }


        String title = args[2];
        String author = args[3];


        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
             PtlParamOutput outputFile = new PtlParamOutput(args[1]);
             PtlPDFDocument doc = new PtlPDFDocument()) {
            // PDFファイルをロード
            doc.load(inputFile);

            try (PtlDocProperty docProperty = doc.getDocProperty(); // PDFの文書プロパティ
                 PtlDocInfo docinf = docProperty.getDocInfo();
                 BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                 PtlDate creationDate = new PtlDate()) {

                // タイトルを設定
                docinf.setTitle(title);
                // 著者を設定
                docinf.setAuthor(author);

                // 作成日付を設定
                System.out.println("作成日付を入力してください。");
                docinf.setCreationDate(setDate(br, creationDate));
                
                // 更新日付を設定(更新時の時間で作成)
                LocalDateTime timeNow = LocalDateTime.now();
                try (PtlDate dateModNew = new PtlDate(timeNow.getYear(),
                                                      timeNow.getMonthValue(),
                                                      timeNow.getDayOfMonth(),
                                                      timeNow.getHour(),
                                                      timeNow.getMinute(),
                                                      timeNow.getSecond())) {
                    docinf.setModDate(dateModNew);
                }
            }

            // ファイルに保存します
            doc.save(outputFile);
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                               "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
    
    
    public static PtlDate setDate(BufferedReader br, PtlDate date)
        throws IOException, PtlException, Exception, Error {
            int year;
            int month;
            int day;
            int hour;
            int minute;
            int second;
            boolean isValueOkay = false;
        
            while(!isValueOkay) {
                System.out.print("year : ");
                year = Integer.parseInt(br.readLine());
                System.out.print("month : ");
                month = Integer.parseInt(br.readLine());
                System.out.print("day : ");
                day = Integer.parseInt(br.readLine());
                System.out.print("hour : ");
                hour = Integer.parseInt(br.readLine());
                System.out.print("minute : ");
                minute = Integer.parseInt(br.readLine());
                System.out.print("second : ");
                second = Integer.parseInt(br.readLine());
            
                date.setYear(year);
                date.setMonth(month);
                date.setDay(day);
                date.setHour(hour);
                date.setMin(minute);
                date.setSec(second);

            
                //PtlDateの数値が正しいかどうかを判定する。
                if(date.isValid()) {
                    isValueOkay = true;
                }else {
                    System.out.println("PtlDateとして保持できない数値が入力されています。");
                    System.out.println("もう一度入力して下さい。");
                }
            }

        return date;
    }
}