/*
  Antenna House PDF Tool API V7.0
  Java Interface sample program

  概要：PDFAであることを確認する

  Copyright (C) 2023- Antenna House, Inc. All rights reserved.
  Antenna House is a trademark of [Antenna House, Inc.]

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

package cookbook;

import jp.co.antenna.ptl.*;

public class ValidatePDFA {

    // そのクラスのusageを表示する関数
    public static void printUsage() {
        System.out.println("usage: java ValidatePDFA in-pdf-file");
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            printUsage(); // usageメッセージの表示
            return;
        }

        // コマンドライン引数の取得
        try (PtlParamInput inputFile = new PtlParamInput(args[0]);
              PtlPDFFixUp fixUp = new PtlPDFFixUp()) {
            // PDFファイルを読み込んで鑑定する
            //PDF/A-1bであるかを判定する
            if(fixUp.validatePDFA(PtlPDFFixUp.PDFA_TYPE.PDFA_1B, inputFile)) {
                System.out.println("このPDFはPDF/A-1bに準拠しています");
            }else if(fixUp.validatePDFA(PtlPDFFixUp.PDFA_TYPE.PDFA_2B, inputFile)) {
                System.out.println("このPDFはPDF/A-2bに準拠しています");
            }else{
                System.out.println("このPDFはPDF/A-1b、PDF/A-2bのどちらにも準拠していません。");
                try(PtlPDFFixUpErrors fixUpErrors = fixUp.getErrors()) {
                    int numErrors = fixUpErrors.getCount();
                    for(int i = 0; i < numErrors; i++) {
                        try(PtlPDFFixUpError thisFixUpError = fixUpErrors.get(i)){
                            System.out.println("エラーその"+ i +"："+ thisFixUpError.getErrorMessageJP());
                        }
                    }
                }
            }
            
        }
        catch (PtlException pex) {
            System.out.println("PtlException : ErrorCode = " + pex.getErrorCode() +
                               "\n  " + pex.getErrorMessage());
        }
        catch (Exception | Error ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            System.out.println("-- 完了 --");
        }
    }
}