/*
 * Decompiled with CFR 0.152.
 */
package jp.co.antenna.dmc.v3;

import java.io.File;
import jp.co.antenna.dmc.v3.DMCException;
import jp.co.antenna.dmc.v3.DMCProperty;
import jp.co.antenna.dmc.v3.DMCTextInfo;
import jp.co.antenna.dmc.v3.DMCfileInfo;

public class DMCnativeV3 {
    public static DMCfileInfo getDMCFileInfo(File file) throws DMCException {
        if (!file.exists()) {
            throw new DMCException(21);
        }
        if (file.isDirectory()) {
            throw new DMCException(3002);
        }
        String string = file.getPath();
        try {
            byte[] byArray = string.getBytes();
            DMCfileInfo dMCfileInfo = DMCnativeV3.getDMCFileInfoV3(byArray);
            return dMCfileInfo;
        }
        catch (DMCException dMCException) {
            throw dMCException;
        }
        catch (Exception exception) {
            throw new DMCException(3000);
        }
    }

    private static native DMCfileInfo getDMCFileInfoV3(byte[] var0) throws Exception;

    private static native int getTextV3(byte[] var0, byte[] var1, DMCTextInfo var2) throws Exception;

    public static void getText(File file, File file2, DMCTextInfo dMCTextInfo) throws DMCException {
        if (!file.exists()) {
            throw new DMCException(21);
        }
        if (file.isDirectory()) {
            throw new DMCException(3002);
        }
        byte[] byArray = file.getPath().getBytes();
        byte[] byArray2 = file2.getPath().getBytes();
        try {
            int n = DMCnativeV3.getTextV3(byArray, byArray2, dMCTextInfo);
            if (n != 0) {
                throw new DMCException(n);
            }
        }
        catch (DMCException dMCException) {
            throw dMCException;
        }
        catch (Exception exception) {
            throw new DMCException(3000);
        }
    }

    public static int getPageText(File file, File file2, DMCTextInfo dMCTextInfo, int n) throws DMCException {
        if (!file.exists()) {
            throw new DMCException(21);
        }
        if (file.isDirectory()) {
            throw new DMCException(3002);
        }
        byte[] byArray = file.getPath().getBytes();
        byte[] byArray2 = file2.getPath().getBytes();
        try {
            int n2 = DMCnativeV3.getPageTextV3(byArray, byArray2, dMCTextInfo, n);
            if (n != 0 && n2 != 0) {
                throw new DMCException(n2);
            }
            return n2;
        }
        catch (DMCException dMCException) {
            throw dMCException;
        }
        catch (Exception exception) {
            throw new DMCException(3000);
        }
    }

    private static native int getPageTextV3(byte[] var0, byte[] var1, DMCTextInfo var2, int var3) throws DMCException;

    private static native int getPwdPageTextV3(byte[] var0, byte[] var1, DMCTextInfo var2, int var3, byte[] var4) throws DMCException;

    public static int getPwdPageText(File file, File file2, DMCTextInfo dMCTextInfo, int n, String string) throws DMCException {
        if (!file.exists()) {
            throw new DMCException(21);
        }
        if (file.isDirectory()) {
            throw new DMCException(3002);
        }
        byte[] byArray = file.getPath().getBytes();
        byte[] byArray2 = file2.getPath().getBytes();
        byte[] byArray3 = string.getBytes();
        try {
            int n2 = DMCnativeV3.getPwdPageTextV3(byArray, byArray2, dMCTextInfo, n, byArray3);
            if (n != 0 && n2 != 0) {
                throw new DMCException(n2);
            }
            return n2;
        }
        catch (DMCException dMCException) {
            throw dMCException;
        }
        catch (Exception exception) {
            throw new DMCException(3000);
        }
    }

    public static void getPwdText(File file, File file2, DMCTextInfo dMCTextInfo, String string) throws DMCException {
        if (!file.exists()) {
            throw new DMCException(21);
        }
        if (file.isDirectory()) {
            throw new DMCException(3002);
        }
        byte[] byArray = file.getPath().getBytes();
        byte[] byArray2 = file2.getPath().getBytes();
        byte[] byArray3 = string.getBytes();
        try {
            int n = DMCnativeV3.getPwdTextV3(byArray, byArray2, dMCTextInfo, byArray3);
            if (n != 0) {
                throw new DMCException(n);
            }
        }
        catch (DMCException dMCException) {
            throw dMCException;
        }
        catch (Exception exception) {
            throw new DMCException(3000);
        }
    }

    private static native int getPwdTextV3(byte[] var0, byte[] var1, DMCTextInfo var2, byte[] var3) throws Exception;

    private static native int getProperty(byte[] var0, DMCTextInfo var1, DMCProperty var2);

    public static void getProperty(File file, DMCTextInfo dMCTextInfo, DMCProperty dMCProperty) throws DMCException {
        if (!file.exists()) {
            throw new DMCException(21);
        }
        if (file.isDirectory()) {
            throw new DMCException(3002);
        }
        byte[] byArray = file.getPath().getBytes();
        int n = DMCnativeV3.getProperty(byArray, dMCTextInfo, dMCProperty);
        if (n != 0) {
            throw new DMCException(n);
        }
    }

    private static native int getPwdProperty(byte[] var0, DMCTextInfo var1, DMCProperty var2, byte[] var3);

    public static void getPwdProperty(File file, DMCTextInfo dMCTextInfo, DMCProperty dMCProperty, String string) throws DMCException {
        byte[] byArray;
        if (!file.exists()) {
            throw new DMCException(21);
        }
        if (file.isDirectory()) {
            throw new DMCException(3002);
        }
        byte[] byArray2 = file.getPath().getBytes();
        int n = DMCnativeV3.getPwdProperty(byArray2, dMCTextInfo, dMCProperty, byArray = string.getBytes());
        if (n != 0) {
            throw new DMCException(n);
        }
    }

    static {
        System.loadLibrary("dmcjava");
    }
}

