/*
 * Decompiled with CFR 0.152.
 */
package jp.co.antenna.dmc.v4;

public class DMCExceptionV4
extends Exception {
    private int errorReason;
    public static final int SystemError = 11;
    public static final int MemoryNotEnough = 12;
    public static final int UserAbort = 13;
    public static final int FileNotFound = 21;
    public static final int FileCantOpen = 22;
    public static final int FileCantCreate = 23;
    public static final int FileCantWrite = 24;
    public static final int FileCantRead = 25;
    public static final int FileCantDelete = 26;
    public static final int FilePathTooLong = 27;
    public static final int DllLoadFailed = 1001;
    public static final int DllFuncCantFound = 1002;
    public static final int CantInitialize = 1003;
    public static final int LicenseFileNotFound = 1004;
    public static final int CantDetectFile = 2001;
    public static final int NotSuppoted = 2002;
    public static final int TimeOut = 2003;
    public static final int LanguageNotSupported = 2004;
    public static final int OtherProblems = 3000;
    public static final int ProtectedByPassword = 3001;
    public static final int InvalidFile = 3002;
    public static final int NoTextStringFound = 3003;
    public static final int StoppedByOle = 3004;
    public static final int FileLengthOver = 3005;
    public static final int MaxLoopCounts = 3006;
    public static final int CompressDateUncompress = 3007;
    public static final int OleCantDetectFile = 4000;
    public static final int OleNotSuppoted = 4001;
    public static final int OleProtectedBypassWord = 4002;
    public static final int OleInvalidFile = 4003;
    public static final int OleNoTextStringFound = 4004;
    public static final int OleOutOfLimit = 4005;
    public static final int InsertFileOutOfLimit = 4006;
    public static final int InsertFileNotSuppoted = 4007;
    public static final int InsertFileNoTextStringFound = 4008;
    public static final int ProtectedByPassWordPDF = 5000;
    public static final int WrongPassWord = 5001;
    public static final int PWDfileNotSuppoted = 5002;
    public static final int ProtectedByOwnerPassWordPDF = 5003;
    public static final int CompressedFileCantDetect = 6000;
    public static final int CompressedFileNotSuppoted = 6001;
    public static final int CompressedFileNoTextStringFound = 6002;
    public static final int CompressedFileInvalidfile = 6003;
    public static final int CompressedFileByPassWord = 6004;
    public static final int CompressedFileOutOfLimit = 6005;
    public static final int StoppedByCompressedFile = 6006;

    public DMCExceptionV4(int n) {
        super("DMC Error  Errorcode " + n);
        this.errorReason = n;
    }

    public boolean isFileError() {
        return 0 < this.errorReason && this.errorReason < 1000;
    }

    public boolean isDLLError() {
        return 1000 < this.errorReason && this.errorReason < 2000;
    }

    public boolean isDetectError() {
        return 2000 < this.errorReason && this.errorReason < 3000;
    }

    public boolean isTextError() {
        return 3000 < this.errorReason && this.errorReason < 4000;
    }

    public boolean isOleError() {
        return 4000 < this.errorReason && this.errorReason < 5000;
    }

    public boolean isPwdError() {
        return 5000 < this.errorReason && this.errorReason < 6000;
    }

    public boolean isCmpError() {
        return 6000 < this.errorReason && this.errorReason < 7000;
    }

    public int getErrorReason() {
        return this.errorReason;
    }
}

