#! /usr/bin/perl -Tw
#
# Perl5 script for DMC_GetTextV4()
# 
# usage: GetTextV4 inpath outpath
#

use strict;
use DMC_Perl::DMC_Perl;

if (@ARGV < 2) {
	print "usage: GetText inpath outpath\n";
	exit;
}
my $tinfo = new DMC_Perl::DMC_TEXTINFO_V4();

$tinfo->{GroupName} = "Shift_JIS";
$tinfo->{DefLangName} = "Japanese";
$tinfo->{bBigEndian} = $DMC_Perl::DMC_TRUE;
$tinfo->{Option} = $DMC_Perl::DMC_GETTEXT_OPT_OLE|$DMC_Perl::DMC_GETTEXT_OPT_OLE2|$DMC_Perl::DMC_GETTEXT_OPT_OLE3;
$tinfo->{Option1} = 0;
$tinfo->{Csv_c} = ord ",";

my $iRet = DMC_Perl::DMC_GetText_V4($ARGV[0], $ARGV[1], $tinfo,$DMC_Perl::CallBackFunc);

if ($iRet != 0) {
	print "DMC_GetText_V4() return error code ".$iRet.".\n";
}

$tinfo->DESTROY();
