#! /usr/bin/perl -Tw
#
# Perl5 script for DMC_GetProperty()
# 
# usage: GetProperty filepath
#

use strict;
use DMC_Perl::DMC_Perl;

if (@ARGV == 0) {
	print "usage: GetProperty filepath\n";
	exit;
}

my $tinfo = new DMC_Perl::DMC_TEXTINFO();
my $prop = new DMC_Perl::DMC_PROPERTY();

$tinfo->{GroupName} = "Shift_JIS";
$tinfo->{DefLangName} = "Japanese";
$tinfo->{bBigEndian} = $DMC_Perl::DMC_TRUE;
$tinfo->{Option} = 0;
$tinfo->{Option1} = 0;
$tinfo->{Size} = 1024;
$tinfo->{Csv_c} = ord ",";

my $iRet = DMC_Perl::DMC_GetProperty_V3($ARGV[0], $tinfo, $prop);

if ($iRet == 0) {
	print "title      = '".$prop->{title}."'\n";
	print "author     = '".$prop->{author}."'\n";
	print "keyword    = '".$prop->{keyword}."'\n";
	print "subject    = '".$prop->{subject}."'\n";
	print "comment    = '".$prop->{comment}."'\n";
	print "manager    = '".$prop->{manager}."'\n";
	print "company    = '".$prop->{company}."'\n";
	print "category   = '".$prop->{category}."'\n";
	print "createdate = '".$prop->{createdate}."'\n";
} else {
	print "DMC_GetProperty() return error code ".$iRet.".\n";
}

undef $tinfo->{GroupName};
undef $tinfo->{DefLangName};

$prop->DESTROY();
$tinfo->DESTROY();
