#include "stream_oem.h"

BOOL CallBackFunc1(LDDMC_OLEERR* OleErr)
{
	printf("This OleErr is level %d\n",OleErr->LevNum);
	printf("This OleErr's code is %d\n",OleErr->ErrCode);
	printf("This OleErr's Engine is %s\n",OleErr->DtctResult);
 	if (OleErr->ErrCode) return DMC_TRUE; // 2007/05/24 by show
	return DMC_FALSE;
}
INT ToStreamDmc(Byte* Appfile,Byte* txtfile,DMC_TEXTINFO_V4* TextInfo)
{
	int iRet=0,len=0;
	fstream ofile;

	ofile.open((const char *)txtfile,ios::in|ios::out|ios::binary|ios::trunc);
	iRet= DMC_GetTextStream_V4(Appfile,&ofile, TextInfo,(DMC_OLEERR_CALLBACK)CallBackFunc1);
	len=ofile.tellp();
	ofile.close();
	if(len==0){
		remove((const char *)txtfile);
	}
	if( iRet == 0 ) {
		printf("GetTextStream_V4 from %s to %s succeeded.\n", Appfile, txtfile);
	}
	else {
		printf("GetTextStream_V4 from %s to %s failed, error code: %d\n", Appfile, txtfile, iRet);
		if(((TextInfo->Option & DMC_GETTEXT_OPT_OLE)==0)&&
			((TextInfo->Option1 & DMC_GETTEXT_OPT1_INSERTF)==0)) { //quman add 
			// o̓TCYI[o[Ȃt@CȂ悤ɏCB
			// 2008/04/18 by show
			if (iRet != FileLengthOver) {
				remove((const char *)txtfile);
			}
		}
	}
	return iRet;
}
	
INT ToPageStreamDmc(Byte* Appfile,Byte* txtfile,DMC_TEXTINFO_V4* TextInfo,int* Pages)//quman 041213
{
	int iRet=0,len=0;
	fstream ofile;

	ofile.open((const char *)txtfile,ios::in|ios::out|ios::binary|ios::trunc);
	iRet= DMC_GetPageTextStream_V4(Appfile,&ofile, TextInfo,Pages,(DMC_OLEERR_CALLBACK)CallBackFunc1);
	len=ofile.tellp();
	ofile.close();
	if(len==0){
		remove((const char *)txtfile);
	}
	if( iRet == 0 ) {
		printf("GetPageTextStream_V4 from %s to %s succeeded, total pages: %d.\n", Appfile, txtfile, *Pages);
	}
	else {
		printf("GetPageTextStream_V4 from %s to %s failed, error code: %d\n", Appfile, txtfile, iRet);
		if(((TextInfo->Option & DMC_GETTEXT_OPT_OLE)==0)&&
			((TextInfo->Option1 & DMC_GETTEXT_OPT1_INSERTF)==0)) { //quman add 
			// o̓TCYI[o[Ȃt@CȂ悤ɏCB
			// 2008/04/18 by show
			if (iRet != FileLengthOver) {
				remove((const char *)txtfile);
			}
		}
	}
	return iRet;
}
