#! /usr/bin/perl -Tw
#
# Perl5 script for DMC_GetText_V3()
# 
# usage: GetText inpath outpath
#

use strict;
use DMC_Perl::DMC_Perl;

if (@ARGV < 2) {
	print "usage: GetText inpath outpath\n";
	exit;
}

my $tinfo = new DMC_Perl::DMC_TEXTINFO();

$tinfo->{GroupName} = "Shift_JIS";
$tinfo->{DefLangName} = "Japanese";
$tinfo->{bBigEndian} = $DMC_Perl::DMC_TRUE;
$tinfo->{Option} = 0;
$tinfo->{Option1} = 0;
$tinfo->{Csv_c} = ord ",";

my $iRet = DMC_Perl::DMC_GetText_V3($ARGV[0], $ARGV[1], $tinfo);

if ($iRet != 0) {
	print "DMC_GetText_V3() return error code ".$iRet.".\n";
}

undef $tinfo->{GroupName};
undef $tinfo->{DefLangName};

$tinfo->DESTROY();
