/* only use for multi-thread programing */

#ifndef _THR_FUNC_H_
#define _THR_FUNC_H_

#if defined DMC_WIN
	#include <io.h>
#else
	#include <pthread.h>
#endif // #if defined DMC_WIN

#define MAX_PASSWORD_LEN 256

#if defined DMC_WIN
	#define MAX_PATH_LEN _MAX_PATH
#else
	#define MAX_PATH_LEN 255
#endif // #if defined DMC_WIN

typedef struct {
	char		 password[MAX_PASSWORD_LEN];
	int			 pages;
	DMC_FILEINFO fileInfo;
	DMC_PROPERTY property;
	DMC_TEXTINFO textInfo;
	DMC_TEXTINFO_V4 textInfo_V4;
	Byte		 appfile[MAX_PATH_LEN];
	Byte		 txtfile[MAX_PATH_LEN];
	BOOL		 bFinished;
} THR_DATA;

#if defined DMC_WIN
typedef struct 
{ 
    int           handle;
    struct _wfinddata_t  entry;
    struct _finddata_t  ascentry;
    Bool           first;     
} DMC_DIR;//030324
#endif

#if defined DMC_WIN
	typedef unsigned RESULT_TYPE;
	#define CALLING __stdcall
#else
	typedef void* RESULT_TYPE;
	#define CALLING 
#endif // #if defined DMC_WIN

extern RESULT_TYPE CALLING thr_GetText(void *arg);
extern RESULT_TYPE CALLING thr_GetPageText(void *arg);
extern RESULT_TYPE CALLING thr_GetProperty(void *arg);
extern RESULT_TYPE CALLING thr_GetPwdText(void *arg);
extern RESULT_TYPE CALLING thr_GetPwdPageText(void *arg);
extern RESULT_TYPE CALLING thr_GetPwdProperty(void *arg);

extern RESULT_TYPE CALLING thr_GetText_V4(void *arg);
extern RESULT_TYPE CALLING thr_GetPageText_V4(void *arg);
extern RESULT_TYPE CALLING thr_GetProperty_V4(void *arg);
extern RESULT_TYPE CALLING thr_GetPwdText_V4(void *arg);
extern RESULT_TYPE CALLING thr_GetPwdPageText_V4(void *arg);
extern RESULT_TYPE CALLING thr_GetPwdProperty_V4(void *arg);

extern RESULT_TYPE CALLING thr_GetTextStream_V4(void *arg);
extern RESULT_TYPE CALLING thr_GetPageTextStream_V4(void *arg);

extern int WritePropertyToFile(const char* filename, DMC_PROPERTY* Property,Byte* GroupName);

#endif
