﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace To_com_vcs {
	public partial class FormOptionDlg : Form {
		public FormOptionDlg() {
			InitializeComponent();
		}

		public long option = 0;
		private Dictionary<CheckBox, long> optionValueMap = new Dictionary<CheckBox, long>();

		private void FormOptionDlg_Load(object sender, EventArgs e) {
			optionValueMap.Clear();
			optionValueMap.Add(chkDMC_GETTEXT_OPT_KEISEN, 0x00000001);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_TAG, 0x00000002);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_RUBI, 0x00000004);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_CRLF, 0x00000008);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_CR, 0x00000010);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_LF, 0x00000020);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_U2028, 0x00000040);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_U2029, 0x00000080);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_SHEET, 0x00000100);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_PWD, 0x00000400);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_OLE, 0x00001000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_OLE1, 0x00002000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_OLE2, 0x00004000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_OLE3, 0x00008000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_OUT, 0x00010000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_LOOP, 0x00020000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_SHFTAG, 0x00040000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_SHFHEAD, 0x00080000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_SHEET1, 0x00100000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_CELL, 0x00200000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_SIZE, 0x00400000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_PDFSYM, 0x00800000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_CSV1, 0x01000000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_CSV2, 0x02000000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_ENDCODE, 0x04000000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_NULL, 0x08000000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_OWNERPWD1, 0x10000000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_OWNERPWD2, 0x20000000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_OWNERPWD3, 0x40000000);
			optionValueMap.Add(chkDMC_GETTEXT_OPT_OWNERPWD4, 0x80000000);
			foreach (CheckBox chk in optionValueMap.Keys) {
				chk.Checked = (option & optionValueMap[chk]) != 0;
			}
		}

		private void btnOK_Click(object sender, EventArgs e) {
			option = 0;
			foreach (CheckBox chk in optionValueMap.Keys) {
				if (chk.Checked)
					option |= optionValueMap[chk];
			}
		}
	}
}
