#! /usr/bin/perl
#
# Perl5 script for DMC_GetPwdText_V4()
# 
# usage: GetPwdText inpath outpath
#

use strict;
use DMC_Perl::DMC_Perl;

if (@ARGV < 3) {
	print "usage: GetPwdText inpath outpath password\n";
	exit;
}

my $tinfo = new DMC_Perl::DMC_TEXTINFO_V4();

$tinfo->{GroupName} = "Shift_JIS";
$tinfo->{DefLangName} = "Japanese";
$tinfo->{bBigEndian} = $DMC_Perl::DMC_TRUE;
$tinfo->{Option} = $DMC_Perl::DMC_GETTEXT_OPT_PWD;
$tinfo->{Option1} = 0;
$tinfo->{Csv_c} = ord ",";

my $iRet = DMC_Perl::DMC_GetPwdText_V4($ARGV[0], $ARGV[1], $tinfo, $ARGV[2], $DMC_Perl::CallBackFunc);

if ($iRet != 0) {
	print "DMC_GetPwdText_V4() return error code ".$iRet.".\n";
}

$tinfo->DESTROY();
