/*
 * Decompiled with CFR 0.152.
 */
package jp.co.antenna.dmc.v5;

import java.io.File;
import java.io.OutputStream;
import jp.co.antenna.dmc.v5.DMCExceptionV5;
import jp.co.antenna.dmc.v5.DMCFileInfoV5;
import jp.co.antenna.dmc.v5.DMCOLEErr;
import jp.co.antenna.dmc.v5.DMCPropertyV5;
import jp.co.antenna.dmc.v5.DMCTextInfoV5;
import jp.co.antenna.dmc.v5.InterestingEvent;

public class TextPorterV5 {
    private static InterestingEvent Event;

    private static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string.startsWith("Windows");
    }

    public static DMCFileInfoV5 getDMCFileInfoV5(File file, DMCTextInfoV5 dMCTextInfoV5) throws DMCExceptionV5 {
        if (!file.exists()) {
            throw new DMCExceptionV5(21);
        }
        if (file.isDirectory()) {
            throw new DMCExceptionV5(3002);
        }
        String string = file.getPath();
        try {
            byte[] byArray = string.getBytes();
            DMCFileInfoV5 dMCFileInfoV5 = TextPorterV5.getDMCFileInfoV5(byArray, dMCTextInfoV5);
            return dMCFileInfoV5;
        }
        catch (DMCExceptionV5 dMCExceptionV5) {
            throw dMCExceptionV5;
        }
        catch (Exception exception) {
            throw new DMCExceptionV5(3000);
        }
    }

    public static DMCFileInfoV5 getDMCFileInfoV5W(File file, DMCTextInfoV5 dMCTextInfoV5) throws DMCExceptionV5 {
        if (!TextPorterV5.isWindows()) {
            throw new DMCExceptionV5(100000);
        }
        if (!file.exists()) {
            throw new DMCExceptionV5(21);
        }
        if (file.isDirectory()) {
            throw new DMCExceptionV5(3002);
        }
        try {
            char[] cArray = file.getPath().toCharArray();
            DMCFileInfoV5 dMCFileInfoV5 = TextPorterV5.getDMCFileInfoV5W(cArray, dMCTextInfoV5);
            return dMCFileInfoV5;
        }
        catch (DMCExceptionV5 dMCExceptionV5) {
            throw dMCExceptionV5;
        }
        catch (Exception exception) {
            throw new DMCExceptionV5(3000);
        }
    }

    public static void getTextV5(File file, File file2, DMCTextInfoV5 dMCTextInfoV5) throws DMCExceptionV5 {
        if (!file.exists()) {
            throw new DMCExceptionV5(21);
        }
        if (file.isDirectory()) {
            throw new DMCExceptionV5(3002);
        }
        try {
            byte[] byArray = file.getPath().getBytes();
            byte[] byArray2 = file2.getPath().getBytes();
            int n = TextPorterV5.getTextV5(byArray, byArray2, dMCTextInfoV5);
            if (n != 0) {
                throw new DMCExceptionV5(n);
            }
        }
        catch (DMCExceptionV5 dMCExceptionV5) {
            throw dMCExceptionV5;
        }
        catch (Exception exception) {
            throw new DMCExceptionV5(3000);
        }
    }

    public static void getTextV5W(File file, File file2, DMCTextInfoV5 dMCTextInfoV5) throws DMCExceptionV5 {
        if (!TextPorterV5.isWindows()) {
            throw new DMCExceptionV5(100000);
        }
        if (!file.exists()) {
            throw new DMCExceptionV5(21);
        }
        if (file.isDirectory()) {
            throw new DMCExceptionV5(3002);
        }
        try {
            char[] cArray = file.getPath().toCharArray();
            char[] cArray2 = file2.getPath().toCharArray();
            int n = TextPorterV5.getTextV5W(cArray, cArray2, dMCTextInfoV5);
            if (n != 0) {
                throw new DMCExceptionV5(n);
            }
        }
        catch (DMCExceptionV5 dMCExceptionV5) {
            throw dMCExceptionV5;
        }
        catch (Exception exception) {
            throw new DMCExceptionV5(3000);
        }
    }

    public static int getPageTextV5(File file, File file2, DMCTextInfoV5 dMCTextInfoV5, int n) throws DMCExceptionV5 {
        if (!file.exists()) {
            throw new DMCExceptionV5(21);
        }
        if (file.isDirectory()) {
            throw new DMCExceptionV5(3002);
        }
        try {
            byte[] byArray = file.getPath().getBytes();
            byte[] byArray2 = file2.getPath().getBytes();
            int n2 = TextPorterV5.getPageTextV5(byArray, byArray2, dMCTextInfoV5, n);
            if (n != 0 && n2 != 0) {
                throw new DMCExceptionV5(n2);
            }
            return n2;
        }
        catch (DMCExceptionV5 dMCExceptionV5) {
            throw dMCExceptionV5;
        }
        catch (Exception exception) {
            throw new DMCExceptionV5(3000);
        }
    }

    public static int getPageTextV5W(File file, File file2, DMCTextInfoV5 dMCTextInfoV5, int n) throws DMCExceptionV5 {
        if (!TextPorterV5.isWindows()) {
            throw new DMCExceptionV5(100000);
        }
        if (!file.exists()) {
            throw new DMCExceptionV5(21);
        }
        if (file.isDirectory()) {
            throw new DMCExceptionV5(3002);
        }
        try {
            char[] cArray = file.getPath().toCharArray();
            char[] cArray2 = file2.getPath().toCharArray();
            int n2 = TextPorterV5.getPageTextV5W(cArray, cArray2, dMCTextInfoV5, n);
            if (n != 0 && n2 != 0) {
                throw new DMCExceptionV5(n2);
            }
            return n2;
        }
        catch (DMCExceptionV5 dMCExceptionV5) {
            throw dMCExceptionV5;
        }
        catch (Exception exception) {
            throw new DMCExceptionV5(3000);
        }
    }

    public static int getPwdPageTextV5(File file, File file2, DMCTextInfoV5 dMCTextInfoV5, int n, String string) throws DMCExceptionV5 {
        if (!file.exists()) {
            throw new DMCExceptionV5(21);
        }
        if (file.isDirectory()) {
            throw new DMCExceptionV5(3002);
        }
        try {
            byte[] byArray = file.getPath().getBytes();
            byte[] byArray2 = file2.getPath().getBytes();
            byte[] byArray3 = string.getBytes();
            int n2 = TextPorterV5.getPwdPageTextV5(byArray, byArray2, dMCTextInfoV5, n, byArray3);
            if (n != 0 && n2 != 0) {
                throw new DMCExceptionV5(n2);
            }
            return n2;
        }
        catch (DMCExceptionV5 dMCExceptionV5) {
            throw dMCExceptionV5;
        }
        catch (Exception exception) {
            throw new DMCExceptionV5(3000);
        }
    }

    public static int getPwdPageTextV5W(File file, File file2, DMCTextInfoV5 dMCTextInfoV5, int n, String string) throws DMCExceptionV5 {
        if (!TextPorterV5.isWindows()) {
            throw new DMCExceptionV5(100000);
        }
        if (!file.exists()) {
            throw new DMCExceptionV5(21);
        }
        if (file.isDirectory()) {
            throw new DMCExceptionV5(3002);
        }
        try {
            char[] cArray = file.getPath().toCharArray();
            char[] cArray2 = file2.getPath().toCharArray();
            byte[] byArray = string.getBytes();
            int n2 = TextPorterV5.getPwdPageTextV5W(cArray, cArray2, dMCTextInfoV5, n, byArray);
            if (n != 0 && n2 != 0) {
                throw new DMCExceptionV5(n2);
            }
            return n2;
        }
        catch (DMCExceptionV5 dMCExceptionV5) {
            throw dMCExceptionV5;
        }
        catch (Exception exception) {
            throw new DMCExceptionV5(3000);
        }
    }

    public static void getPwdTextV5(File file, File file2, DMCTextInfoV5 dMCTextInfoV5, String string) throws DMCExceptionV5 {
        if (!file.exists()) {
            throw new DMCExceptionV5(21);
        }
        if (file.isDirectory()) {
            throw new DMCExceptionV5(3002);
        }
        byte[] byArray = file.getPath().getBytes();
        byte[] byArray2 = file2.getPath().getBytes();
        byte[] byArray3 = string.getBytes();
        try {
            int n = TextPorterV5.getPwdTextV5(byArray, byArray2, dMCTextInfoV5, byArray3);
            if (n != 0) {
                throw new DMCExceptionV5(n);
            }
        }
        catch (DMCExceptionV5 dMCExceptionV5) {
            throw dMCExceptionV5;
        }
        catch (Exception exception) {
            throw new DMCExceptionV5(3000);
        }
    }

    public static void getPwdTextV5W(File file, File file2, DMCTextInfoV5 dMCTextInfoV5, String string) throws DMCExceptionV5 {
        if (!TextPorterV5.isWindows()) {
            throw new DMCExceptionV5(100000);
        }
        if (!file.exists()) {
            throw new DMCExceptionV5(21);
        }
        if (file.isDirectory()) {
            throw new DMCExceptionV5(3002);
        }
        try {
            char[] cArray = file.getPath().toCharArray();
            char[] cArray2 = file2.getPath().toCharArray();
            byte[] byArray = string.getBytes();
            int n = TextPorterV5.getPwdTextV5W(cArray, cArray2, dMCTextInfoV5, byArray);
            if (n != 0) {
                throw new DMCExceptionV5(n);
            }
        }
        catch (DMCExceptionV5 dMCExceptionV5) {
            throw dMCExceptionV5;
        }
        catch (Exception exception) {
            throw new DMCExceptionV5(3000);
        }
    }

    public static void getPropertyV5(File file, DMCTextInfoV5 dMCTextInfoV5, DMCPropertyV5 dMCPropertyV5) throws DMCExceptionV5 {
        if (!file.exists()) {
            throw new DMCExceptionV5(21);
        }
        if (file.isDirectory()) {
            throw new DMCExceptionV5(3002);
        }
        byte[] byArray = file.getPath().getBytes();
        int n = TextPorterV5.getPropertyV5(byArray, dMCTextInfoV5, dMCPropertyV5);
        if (n != 0) {
            throw new DMCExceptionV5(n);
        }
    }

    public static void getPropertyV5W(File file, DMCTextInfoV5 dMCTextInfoV5, DMCPropertyV5 dMCPropertyV5) throws DMCExceptionV5 {
        if (!TextPorterV5.isWindows()) {
            throw new DMCExceptionV5(100000);
        }
        if (!file.exists()) {
            throw new DMCExceptionV5(21);
        }
        if (file.isDirectory()) {
            throw new DMCExceptionV5(3002);
        }
        try {
            char[] cArray = file.getPath().toCharArray();
            int n = TextPorterV5.getPropertyV5W(cArray, dMCTextInfoV5, dMCPropertyV5);
            if (n != 0) {
                throw new DMCExceptionV5(n);
            }
        }
        catch (DMCExceptionV5 dMCExceptionV5) {
            throw dMCExceptionV5;
        }
        catch (Exception exception) {
            throw new DMCExceptionV5(3000);
        }
    }

    public static void getPwdPropertyV5(File file, DMCTextInfoV5 dMCTextInfoV5, DMCPropertyV5 dMCPropertyV5, String string) throws DMCExceptionV5 {
        byte[] byArray;
        if (!file.exists()) {
            throw new DMCExceptionV5(21);
        }
        if (file.isDirectory()) {
            throw new DMCExceptionV5(3002);
        }
        byte[] byArray2 = file.getPath().getBytes();
        int n = TextPorterV5.getPwdPropertyV5(byArray2, dMCTextInfoV5, dMCPropertyV5, byArray = string.getBytes());
        if (n != 0) {
            throw new DMCExceptionV5(n);
        }
    }

    public static void getPwdPropertyV5W(File file, DMCTextInfoV5 dMCTextInfoV5, DMCPropertyV5 dMCPropertyV5, String string) throws DMCExceptionV5 {
        if (!TextPorterV5.isWindows()) {
            throw new DMCExceptionV5(100000);
        }
        if (!file.exists()) {
            throw new DMCExceptionV5(21);
        }
        if (file.isDirectory()) {
            throw new DMCExceptionV5(3002);
        }
        try {
            char[] cArray = file.getPath().toCharArray();
            byte[] byArray = string.getBytes();
            int n = TextPorterV5.getPwdPropertyV5W(cArray, dMCTextInfoV5, dMCPropertyV5, byArray);
            if (n != 0) {
                throw new DMCExceptionV5(n);
            }
        }
        catch (DMCExceptionV5 dMCExceptionV5) {
            throw dMCExceptionV5;
        }
        catch (Exception exception) {
            throw new DMCExceptionV5(3000);
        }
    }

    public static void getTextStreamV5(File file, OutputStream outputStream, DMCTextInfoV5 dMCTextInfoV5) throws DMCExceptionV5 {
        if (!file.exists()) {
            throw new DMCExceptionV5(21);
        }
        if (file.isDirectory()) {
            throw new DMCExceptionV5(3002);
        }
        byte[] byArray = file.getPath().getBytes();
        try {
            int n = TextPorterV5.getTextStreamV5(byArray, outputStream, dMCTextInfoV5);
            if (n != 0) {
                throw new DMCExceptionV5(n);
            }
        }
        catch (DMCExceptionV5 dMCExceptionV5) {
            throw dMCExceptionV5;
        }
        catch (Exception exception) {
            throw new DMCExceptionV5(3000);
        }
    }

    public static void getTextStreamV5W(File file, OutputStream outputStream, DMCTextInfoV5 dMCTextInfoV5) throws DMCExceptionV5 {
        if (!TextPorterV5.isWindows()) {
            throw new DMCExceptionV5(100000);
        }
        if (!file.exists()) {
            throw new DMCExceptionV5(21);
        }
        if (file.isDirectory()) {
            throw new DMCExceptionV5(3002);
        }
        try {
            char[] cArray = file.getPath().toCharArray();
            int n = TextPorterV5.getTextStreamV5W(cArray, outputStream, dMCTextInfoV5);
            if (n != 0) {
                throw new DMCExceptionV5(n);
            }
        }
        catch (DMCExceptionV5 dMCExceptionV5) {
            throw dMCExceptionV5;
        }
        catch (Exception exception) {
            throw new DMCExceptionV5(3000);
        }
    }

    public static int getPageTextStreamV5(File file, OutputStream outputStream, DMCTextInfoV5 dMCTextInfoV5, int n) throws DMCExceptionV5 {
        if (!file.exists()) {
            throw new DMCExceptionV5(21);
        }
        if (file.isDirectory()) {
            throw new DMCExceptionV5(3002);
        }
        byte[] byArray = file.getPath().getBytes();
        try {
            int n2 = TextPorterV5.getPageTextStreamV5(byArray, outputStream, dMCTextInfoV5, n);
            if (n != 0 && n2 != 0) {
                throw new DMCExceptionV5(n2);
            }
            return n2;
        }
        catch (DMCExceptionV5 dMCExceptionV5) {
            throw dMCExceptionV5;
        }
        catch (Exception exception) {
            throw new DMCExceptionV5(3000);
        }
    }

    public static int getPageTextStreamV5W(File file, OutputStream outputStream, DMCTextInfoV5 dMCTextInfoV5, int n) throws DMCExceptionV5 {
        if (!TextPorterV5.isWindows()) {
            throw new DMCExceptionV5(100000);
        }
        if (!file.exists()) {
            throw new DMCExceptionV5(21);
        }
        if (file.isDirectory()) {
            throw new DMCExceptionV5(3002);
        }
        try {
            char[] cArray = file.getPath().toCharArray();
            int n2 = TextPorterV5.getPageTextStreamV5W(cArray, outputStream, dMCTextInfoV5, n);
            if (n != 0 && n2 != 0) {
                throw new DMCExceptionV5(n2);
            }
            return n2;
        }
        catch (DMCExceptionV5 dMCExceptionV5) {
            throw dMCExceptionV5;
        }
        catch (Exception exception) {
            throw new DMCExceptionV5(3000);
        }
    }

    public static void setCallBackV5(InterestingEvent interestingEvent) {
        if (interestingEvent != null) {
            Event = interestingEvent;
        }
    }

    private boolean executeCallBackV5(DMCOLEErr dMCOLEErr) {
        if (Event != null) {
            return Event.interestingEvent(dMCOLEErr);
        }
        return true;
    }

    private static native DMCFileInfoV5 getDMCFileInfoV5(byte[] var0, DMCTextInfoV5 var1) throws Exception;

    private static native int getTextV5(byte[] var0, byte[] var1, DMCTextInfoV5 var2) throws Exception;

    private static native int getPageTextV5(byte[] var0, byte[] var1, DMCTextInfoV5 var2, int var3) throws DMCExceptionV5;

    private static native int getPwdPageTextV5(byte[] var0, byte[] var1, DMCTextInfoV5 var2, int var3, byte[] var4) throws DMCExceptionV5;

    private static native int getPwdTextV5(byte[] var0, byte[] var1, DMCTextInfoV5 var2, byte[] var3) throws Exception;

    private static native int getPropertyV5(byte[] var0, DMCTextInfoV5 var1, DMCPropertyV5 var2);

    private static native int getPwdPropertyV5(byte[] var0, DMCTextInfoV5 var1, DMCPropertyV5 var2, byte[] var3);

    private static native int getTextStreamV5(byte[] var0, OutputStream var1, DMCTextInfoV5 var2) throws Exception;

    private static native int getPageTextStreamV5(byte[] var0, OutputStream var1, DMCTextInfoV5 var2, int var3) throws DMCExceptionV5;

    private static native DMCFileInfoV5 getDMCFileInfoV5W(char[] var0, DMCTextInfoV5 var1) throws Exception;

    private static native int getTextV5W(char[] var0, char[] var1, DMCTextInfoV5 var2) throws Exception;

    private static native int getPageTextV5W(char[] var0, char[] var1, DMCTextInfoV5 var2, int var3) throws DMCExceptionV5;

    private static native int getPwdPageTextV5W(char[] var0, char[] var1, DMCTextInfoV5 var2, int var3, byte[] var4) throws DMCExceptionV5;

    private static native int getPwdTextV5W(char[] var0, char[] var1, DMCTextInfoV5 var2, byte[] var3) throws Exception;

    private static native int getPropertyV5W(char[] var0, DMCTextInfoV5 var1, DMCPropertyV5 var2);

    private static native int getPwdPropertyV5W(char[] var0, DMCTextInfoV5 var1, DMCPropertyV5 var2, byte[] var3);

    private static native int getTextStreamV5W(char[] var0, OutputStream var1, DMCTextInfoV5 var2) throws Exception;

    private static native int getPageTextStreamV5W(char[] var0, OutputStream var1, DMCTextInfoV5 var2, int var3) throws DMCExceptionV5;

    static {
        System.loadLibrary("dmcjava");
    }
}

