/*
 * Sample Program for TextPorter
 *
 * Copyright (C) 2009, AntennaHouse Inc.  All Rights Reserved
 *
 * 2009.10.28 Takeshi Yoneki
 */

/* only use for multi-thread programing */

#ifndef _THR_FUNC_H_
#define _THR_FUNC_H_

//#include <stdio.h>
//#include <stdlib.h>
#include <string.h>
#include <string>

#if defined DMC_WIN
	#include <io.h>
#else
	#include <pthread.h>
#endif // #if defined DMC_WIN

#define MAX_PASSWORD_LEN 256

#if defined DMC_WIN
	#define MAX_PATH_LEN (_MAX_PATH * 3)
#else
	#define MAX_PATH_LEN (255 * 3)
#endif // #if defined DMC_WIN

enum PARAM_ENCODE {
	PE_NONE = 0,
	PE_ASIS = 1,
	PE_UTF8,
	PE_UTF16LE = 100,
	PE_UTF16BE
};

enum FUNC_TYPE {
	FT_GET_TEXT_V5 = 0,
	FT_GET_PAGE_TEXT_V5,
	FT_GET_PROPERTY_V5,
	FT_GET_PWD_TEXT_V5,
	FT_GET_PWD_PAGE_TEXT_V5,
	FT_GET_PWD_PROPERTY_V5,
	FT_GET_TEXT_STREAM_V5,
	FT_GET_PAGE_TEXT_STREAM_V5,
	FT_GET_TEXT_V4,
	FT_GET_PAGE_TEXT_V4,
	FT_GET_PROPERTY_V4,
	FT_GET_PWD_TEXT_V4,
	FT_GET_PWD_PAGE_TEXT_V4,
	FT_GET_PWD_PROPERTY_V4,
	FT_GET_TEXT_STREAM_V4,
	FT_GET_PAGE_TEXT_STREAM_V4,
	
	FT_TERMINATE = FT_GET_PAGE_TEXT_STREAM_V4
};

#if defined DMC_WIN
std::string UTF16To8(const std::wstring s);
std::wstring UTF8To16(const std::string s);
std::wstring AnsiToUTF16(const std::string s);
void TransUTF16ToUTF8(char *dst8, const wchar_t *src16, int dstBytes);
void TransUTF8ToUTF16(wchar_t *dst16, const char *stc8, int dstChars);
#endif

class CCmdFilePath {
public:
	std::string m_value;
#ifdef DMC_WIN
	std::wstring m_wvalue;
#endif
	PARAM_ENCODE m_paramEncode;
public:
	CCmdFilePath(std::string value, PARAM_ENCODE paramEncode) {
		m_value = value;
		m_paramEncode = paramEncode;
#ifdef DMC_WIN
		m_wvalue = L"";
		if (m_paramEncode == PE_UTF8) {
			m_wvalue = UTF8To16(m_value);
		}
#endif
	}
	operator Byte *() {
		return (Byte *)m_value.c_str();
	}
	operator char *() {
		return (char *)m_value.c_str();
	}
	operator const char *() {
		return (const char *)m_value.c_str();
	}
#ifdef DMC_WIN
	operator Word *() {
		return (Word *)m_wvalue.c_str();
	}
	operator const wchar_t *() {
		return (const wchar_t *)m_wvalue.c_str();
	}
#endif
	void print() {
#ifdef DMC_WIN
		if (m_paramEncode == PE_UTF8) {
			wprintf(L"%s", m_wvalue.c_str());
			return;
		}
#endif
		printf("%s", m_value.c_str());
	}
	FILE *FOpenForWrite() {
#ifdef DMC_WIN
		if (m_paramEncode == PE_UTF8) {
			return _wfopen(m_wvalue.c_str(), L"wb");
		}
#endif
		return fopen(m_value.c_str(), "wb");
	}
	void Remove() {
#ifdef DMC_WIN
		if (m_paramEncode == PE_UTF8) {
			_wremove(m_wvalue.c_str());
			return;
		}
#endif
		remove(m_value.c_str());
	}
};

class CThreadCall {
public:
	std::string m_password;
	int m_pages;
	DMC_FILEINFO m_fileInfo;
	DMC_PROPERTY m_property;
	DMC_TEXTINFO_V4 m_textInfo_V4;
	DMC_TEXTINFO_V5 m_textInfo_V5;
	std::string m_appfile;
	std::string m_txtfile;
	BOOL m_bFinished;
	DWord m_option;
	DWord m_option1;
	PARAM_ENCODE m_paramEncode;
	FUNC_TYPE m_funcType;
	// m_iRet is added for error checking. 2012/12/13 by show
	int m_iRet;

	CThreadCall() {
		m_password = "";
		m_pages = 0;
		memset(&m_fileInfo, 0, sizeof(m_fileInfo));
		memset(&m_property, 0, sizeof(m_property));
		memset(&m_textInfo_V4, 0, sizeof(m_textInfo_V4));
		memset(&m_textInfo_V5, 0, sizeof(m_textInfo_V5));
		m_appfile = "";
		m_txtfile = "";
		m_bFinished = DMC_FALSE;
		m_paramEncode = PE_ASIS;
		m_funcType = FT_GET_TEXT_V5;
		m_iRet = 0;
	}
public:
	int ThreadProc();
	int ToStreamDmc(CCmdFilePath& appfile, CCmdFilePath& txtfile);
} ;//THR_DATA;

#if defined DMC_WIN
	typedef unsigned RESULT_TYPE;
	#define CALLING __stdcall
#else
	typedef void* RESULT_TYPE;
	#define CALLING 
#endif // #if defined DMC_WIN

const char *GetFuncNameByFuncType(FUNC_TYPE funcType);
FUNC_TYPE GetFuncTypeByFuncName(const char *funcName);
extern BOOL ThreadCallBack(LDDMC_OLEERR* OleErr);
extern RESULT_TYPE CALLING ThreadMain(void *arg);

#endif
