﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Globalization;
using System.IO;
using System.Xml.Serialization;

namespace To_com_vcs {
    public partial class FormMain : Form {
        public FormMain() {
            InitializeComponent();
        }

		public String workingDirectory;

		private void btnConvert_Click(object sender, EventArgs e) {

			String savedDirectory = Directory.GetCurrentDirectory();
			Directory.SetCurrentDirectory(workingDirectory);
		
			btnConvert.Enabled = false;
			String appFile = tbAppFile.Text;
			String txtFile = tbTxtFile.Text;
			String password = tbPassword.Text;

			To_comLib.TextPorterFileInfoClass fInfo = new To_comLib.TextPorterFileInfoClass();
			To_comLib.TextPorterTextInfo_V5Class tInfo = new To_comLib.TextPorterTextInfo_V5Class();
			To_comLib.TextPorterPropertyClass prop = new To_comLib.TextPorterPropertyClass();
			To_comLib.TextPorterClass dmc = new To_comLib.TextPorterClass();

			int errCode = 0;
			int pages = 0;
			tInfo.GroupName = cbxGroupName.Text;
			tInfo.DefLangName = cbxDefLangName.Text;
			tInfo.bBigEndian = chkBigEndian.Checked ? 1 : 0;
			try { pages = Int32.Parse(tbPages.Text); } 
			catch (Exception) { }
			try { tInfo.Csv_c = Int32.Parse(tbCsv_c.Text); } 
			catch (Exception) { }
			try { tInfo.Size = Int32.Parse(tbSize.Text); } 
			catch (Exception) { }
			try { tInfo.Option = (int)Int64.Parse(tbOption.Text, NumberStyles.HexNumber); } 
			catch (Exception) { }
			try { tInfo.Option1 = (int)Int64.Parse(tbOption1.Text, NumberStyles.HexNumber); } 
			catch (Exception) { }
			
			tbErrorCode.Text = "";

			/////////////////////////////////
			String function = cbxFunction.Text;
			if (function == "DMC_GetText_V5W") {
				dmc.GetText_V5W(appFile, txtFile, tInfo, ref errCode);
			}
			else if (function == "DMC_GetPageText_V5W") {
				dmc.GetPageText_V5W(appFile, txtFile, tInfo, ref pages, ref errCode);
			}
			else if (function == "DMC_GetPwdText_V5W") {
				dmc.GetPwdText_V5W(appFile, txtFile, tInfo, password, ref errCode);
			}
			else if (function == "DMC_GetPwdPageText_V5W") {
				dmc.GetPwdPageText_V5W(appFile, txtFile, tInfo, ref pages, password, ref errCode);
			}
			else if (function == "DMC_GetFileInfo_V5W") {
				dmc.GetFileInfo_V5W(appFile, fInfo, tInfo, ref errCode);
			}
			else if (function == "DMC_GetProperty_V5W") {
				dmc.GetProperty_V5W(appFile, tInfo, prop, ref errCode);
			}
			else if (function == "DMC_GetPwdProperty_V5W") {
				dmc.GetPwdProperty_V5W(appFile, tInfo, prop, password, ref errCode);
			}

			/////////////////////////////////

			if (function == "DMC_GetFileInfo_V5W") {
				XmlSerializer serializer = new XmlSerializer(typeof(To_comLib.TextPorterFileInfoClass));
				FileStream fs = new FileStream(txtFile, FileMode.Create);
				if (fs != null) {
					serializer.Serialize(fs, fInfo);
					fs.Close();
				}
			}
			else if (function == "DMC_GetProperty_V5W" || function == "DMC_GetPwdProperty_V5W") {
				XmlSerializer serializer = new XmlSerializer(typeof(To_comLib.TextPorterPropertyClass));
				FileStream fs = new FileStream(txtFile, FileMode.Create);
				if (fs != null) {
					serializer.Serialize(fs, prop);
					fs.Close();
				}
			}

			/////////////////////////////////

			tbErrorCode.Text = errCode.ToString();
			tbPages.Text = pages.ToString();
			btnConvert.Enabled = true;
			btnConvert.Focus();

			Directory.SetCurrentDirectory(savedDirectory);
			return;
		}

		private void btnExit_Click(object sender, EventArgs e) {
			this.Close();
		}

		private void FormMain_Load(object sender, EventArgs e) {
			workingDirectory = Directory.GetCurrentDirectory();
			cbxFunction.Items.Add("DMC_GetText_V5W");
			cbxFunction.Items.Add("DMC_GetPageText_V5W");
			cbxFunction.Items.Add("DMC_GetPwdText_V5W");
			cbxFunction.Items.Add("DMC_GetPwdPageText_V5W");
			cbxFunction.Items.Add("DMC_GetFileInfo_V5W");
			cbxFunction.Items.Add("DMC_GetProperty_V5W");
			cbxFunction.Items.Add("DMC_GetPwdProperty_V5W");
			cbxFunction.SelectedIndex = 0;
			
			cbxGroupName.Items.Add("WINDOWS31J");
			cbxGroupName.Items.Add("Shift_JIS");
			cbxGroupName.Items.Add("ISO-2022-JP");
			cbxGroupName.Items.Add("EUC-JP");
			cbxGroupName.Items.Add("Shift_JIS-2004");
			cbxGroupName.Items.Add("ISO-2022-JP-2004");
			cbxGroupName.Items.Add("EUC-JIS-2004");
			cbxGroupName.Items.Add("UTF-8");
			cbxGroupName.Items.Add("UTF-16");
			cbxGroupName.Items.Add("ISO-10646-UCS-2");
			cbxGroupName.Items.Add("ISO-10646-UCS-4");
			cbxGroupName.Items.Add("ISO8859-1");
			cbxGroupName.Items.Add("ChineseBIG5");
			cbxGroupName.Items.Add("ChineseGBK");
			cbxGroupName.Items.Add("GB18030");
			cbxGroupName.Items.Add("KoreanKSC");
			cbxGroupName.Items.Add("EUC-JP-FIX");
			cbxGroupName.SelectedIndex = 0;

			cbxDefLangName.Items.Add("Japanese");
			cbxDefLangName.Items.Add("English");
			cbxDefLangName.Items.Add("Simplified Chinese");
			cbxDefLangName.Items.Add("Traditional Chinese");
			cbxDefLangName.Items.Add("Korean");
			cbxDefLangName.SelectedIndex = 0;

			chkBigEndian.Checked = true;
		}

		private void btnAppFile_Click(object sender, EventArgs e) {
			try { appFileDialog.InitialDirectory = Path.GetDirectoryName(tbAppFile.Text); } 
			catch (Exception) {}
			try { appFileDialog.FileName = Path.GetFileName(tbAppFile.Text); }
			catch (Exception) { }
			if (appFileDialog.ShowDialog() != DialogResult.OK)
				return;
			tbAppFile.Text = appFileDialog.FileName;
		}

		private void btnTxtFile_Click(object sender, EventArgs e) {
			try { txtFileDialog.InitialDirectory = Path.GetDirectoryName(tbTxtFile.Text); }
			catch (Exception) { }
			try { txtFileDialog.FileName = Path.GetFileName(tbTxtFile.Text); }
			catch (Exception) { }
			if (txtFileDialog.ShowDialog() != DialogResult.OK)
				return;
			tbTxtFile.Text = txtFileDialog.FileName;
		}

		private void button5_Click(object sender, EventArgs e) {
			FormOptionDlg dlg = new FormOptionDlg();
			long option = 0;
			try { option = Int64.Parse(tbOption.Text, NumberStyles.HexNumber); }
			catch (Exception) { }
			dlg.option = option;
			if (dlg.ShowDialog(this) != DialogResult.OK)
				return;
			option = dlg.option;
			tbOption.Text = option.ToString("X");
		}

		private void button6_Click(object sender, EventArgs e) {
			FormOption1Dlg dlg = new FormOption1Dlg();
			long option1 = 0;
			try { option1 = Int64.Parse(tbOption1.Text, NumberStyles.HexNumber); }
			catch (Exception) { }
			dlg.option1 = option1;
			if (dlg.ShowDialog(this) != DialogResult.OK)
				return;
			option1 = dlg.option1;
			tbOption1.Text = option1.ToString("X");
		}
    }
}
