#! /usr/bin/perl -Tw
#
# Perl5 script for DMC_GetFileInfo_V3()
# 
# usage: GetFileInfo filepath
#

use strict;
use DMC_Perl::DMC_Perl;

if (@ARGV == 0) {
	print "usage: GetFileInfo filepath\n";
	exit;
}

my $finfo = new DMC_Perl::DMC_FILEINFO();

my $iRet = DMC_Perl::DMC_GetFileInfo_V3($ARGV[0], $finfo);

if ($iRet == 0) {
	print "DocFormat    = '".$finfo->{DocFormat}."'\n";
	print "DocSubFormat = '".$finfo->{DocSubFormat}."'\n";
	print "DocCountry   = '".$finfo->{DocCountry}."'\n";
	print "ProtectCode  = '".$finfo->{ProtectCode}."'\n";
	print "FileType     = '".$finfo->{FileType}."'\n";
} else {
	print "DMC_GetFileInfo_V3() return error code ".$iRet.".\n";
}

$finfo->DESTROY();
