#! /usr/bin/perl -Tw
#
# Perl5 script for DMC_GetPwdPageText()
# 
# usage: GetPwdPageText inpath outpath pageno password
#

use strict;
use DMC_Perl::DMC_Perl;

if (@ARGV < 4) {
	print "usage: GetPwdPageText inpath outpath pageno password\n";
	exit;
}

my $tinfo = new DMC_Perl::DMC_TEXTINFO();

$tinfo->{GroupName} = "Shift_JIS";
$tinfo->{DefLangName} = "Japanese";
$tinfo->{bBigEndian} = $DMC_Perl::DMC_TRUE;
$tinfo->{Option} = $DMC_Perl::DMC_GETTEXT_OPT_PWD;
$tinfo->{Option1} = 0;
$tinfo->{Csv_c} = ord ",";

# Pointer creation
my $pages = new DMC_Perl::intp();
# Set the Value
$pages->assign($ARGV[2]);

my $iRet = DMC_Perl::DMC_GetPwdPageText_V3($ARGV[0], $ARGV[1], $tinfo, $pages, $ARGV[3]);

if ($iRet == 0) {
	if ($ARGV[2] == "0") {
		# Get the Value
		print "$ARGV[0]: ".$pages->value()."Page.\n";
	}
} else {
	print "DMC_GetPwdPageText() return error code ".$iRet.".\n";
}

# Clean up the pointers
$pages->DESTROY();

undef $tinfo->{GroupName};
undef $tinfo->{DefLangName};

$tinfo->DESTROY();
