#! /usr/bin/perl
#
# Perl5 script for DMC_GetPwdProperty_V4()
# 
# usage: GetPwdProperty filepath password
#

use strict;
use DMC_Perl::DMC_Perl;

if (@ARGV < 2) {
	print "usage: GetPwdProperty filepath password\n";
	exit;
}

my $tinfo = new DMC_Perl::DMC_TEXTINFO_V4();
my $prop = new DMC_Perl::DMC_PROPERTY();

$tinfo->{GroupName} = "Shift_JIS";
$tinfo->{DefLangName} = "Japanese";
$tinfo->{bBigEndian} = $DMC_Perl::DMC_TRUE;
$tinfo->{Option} = $DMC_Perl::DMC_GETTEXT_OPT_PWD;
$tinfo->{Option1} = 0;
$tinfo->{Csv_c} = ord ",";

my $iRet = DMC_Perl::DMC_GetPwdProperty_V4($ARGV[0], $tinfo, $prop, $ARGV[1]);

if ($iRet == 0) {
	print "title      = '".$prop->{title}."'\n";
	print "author     = '".$prop->{author}."'\n";
	print "keyword    = '".$prop->{keyword}."'\n";
	print "subject    = '".$prop->{subject}."'\n";
	print "comment    = '".$prop->{comment}."'\n";
	print "manager    = '".$prop->{manager}."'\n";
	print "company    = '".$prop->{company}."'\n";
	print "category   = '".$prop->{category}."'\n";
	print "createdate = '".$prop->{createdate}."'\n";
} else {
	print "DMC_GetPwdProperty_V4() return error code ".$iRet.".\n";
}

$prop->DESTROY();
$tinfo->DESTROY();
