﻿/*
 * C#ではプロジェクトにこのファイルを加えることでTextPorterを呼び出せます。
 * dmcdotnetif.dllはTextPorterのプラットフォーム(bit数)に合わせてビルドしてください。
 * 他の.NET言語で利用する場合は、このファイルを使ってライブラリを作ってください。
 * Copyright (C) 2015 AntennaHouse Inc.  All Rights Reserved
 */
using System;
using System.Text;
using System.Runtime.InteropServices;
using System.IO;

namespace DMC {
	public class TextInfoV5 {
		public String GroupName = "";
		public String DefLangName = "";
		public Boolean bBigEndian = false;
		public UInt32 Option = 0;
		public UInt32 Option1 = 0;
		public Int64 Size = 0;
		public Int16 Csv_c = 0;
		// GroupName
		public const String EUCJP = "EUC-JP";
		public const String ISO10646_UCS2 = "ISO-10646-UCS-2";
		public const String ISO10646_UCS4 = "ISO-10646-UCS-4";
		public const String ISO2022_JP = "ISO-2022-JP";
		public const String ISO8859_1 = "ISO-8859-1";
		public const String Shift_JIS = "Shift_JIS";
		public const String UTF16 = "UTF-16";
		public const String UTF8 = "UTF-8";
		public const String WINDOWS31J = "WINDOWS31J";
		public const String ChineseGBK = "ChineseGBK";
		public const String ChineseBig5 = "ChineseBIG5";
		public const String ChineseGB18030 = "GB18030";
		public const String KoreanKSC = "KoreanKSC";
		public const String Shift_JIS_2004 = "Shift_JIS-2004";
		public const String ISO_2022_JP_2004 = "ISO-2022-JP-2004";
		public const String EUC_JIS_2004 = "EUC-JIS-2004";
		public const String EUC_JP = "EUC-JP";
		public const String ISO_2022_JP = "ISO-2022-JP";
		// DefLangName
		public const String JAPANESE = "Japanese";
		public const String ENGLISH = "English";
		public const String SIMP_CHINESE = "Simplified Chinese";
		public const String TRAD_CHINESE = "Traditional Chinese";
		public const String KOREAN = "Korean";
		// Option
		public const UInt32 DMC_GETTEXT_OPT_KEISEN = 0x00000001;
		public const UInt32 DMC_GETTEXT_OPT_TAG = 0x00000002;
		public const UInt32 DMC_GETTEXT_OPT_RUBI = 0x00000004;
		public const UInt32 DMC_GETTEXT_OPT_CRLF = 0x00000008;
		public const UInt32 DMC_GETTEXT_OPT_CR = 0x00000010;
		public const UInt32 DMC_GETTEXT_OPT_LF = 0x00000020;
		public const UInt32 DMC_GETTEXT_OPT_U2028 = 0x00000040;
		public const UInt32 DMC_GETTEXT_OPT_U2029 = 0x00000080;
		public const UInt32 DMC_GETTEXT_OPT_SHEET = 0x00000100;
		public const UInt32 DMC_GETTEXT_OPT_PWD = 0x00000400;
		public const UInt32 DMC_GETTEXT_OPT_OLE = 0x00001000;
		public const UInt32 DMC_GETTEXT_OPT_OLE1 = 0x00002000;
		public const UInt32 DMC_GETTEXT_OPT_OLE2 = 0x00004000;
		public const UInt32 DMC_GETTEXT_OPT_OLE3 = 0x00008000;
		public const UInt32 DMC_GETTEXT_OPT_OUT = 0x00010000;
		public const UInt32 DMC_GETTEXT_OPT_LOOP = 0x00020000;
		public const UInt32 DMC_GETTEXT_OPT_SHFTAG = 0x00040000;
		public const UInt32 DMC_GETTEXT_OPT_SHFHEAD = 0x00080000;
		public const UInt32 DMC_GETTEXT_OPT_SHEET1 = 0x00100000;
		public const UInt32 DMC_GETTEXT_OPT_CELL = 0x00200000;
		public const UInt32 DMC_GETTEXT_OPT_SIZE = 0x00400000;
		public const UInt32 DMC_GETTEXT_OPT_PDFSYM = 0x00800000;
		public const UInt32 DMC_GETTEXT_OPT_CSV1 = 0x01000000;
		public const UInt32 DMC_GETTEXT_OPT_CSV2 = 0x02000000;
		public const UInt32 DMC_GETTEXT_OPT_ENDCODE = 0x04000000;
		public const UInt32 DMC_GETTEXT_OPT_NULL = 0x08000000;
		public const UInt32 DMC_GETTEXT_OPT_OWNERPWD1 = 0x10000000;
		public const UInt32 DMC_GETTEXT_OPT_OWNERPWD2 = 0x20000000;
		public const UInt32 DMC_GETTEXT_OPT_OWNERPWD3 = 0x40000000;
		public const UInt32 DMC_GETTEXT_OPT_OWNERPWD4 = 0x80000000;
		// Option1
		public const UInt32 DMC_GETTEXT_OPT1_TEMP = 0x00000001;
		public const UInt32 DMC_GETTEXT_OPT1_INSERTF = 0x00000002;
		public const UInt32 DMC_GETTEXT_OPT1_INSERTF1 = 0x00000004;
		public const UInt32 DMC_GETTEXT_OPT1_INSERTF2 = 0x00000008;
		public const UInt32 DMC_GETTEXT_OPT1_INSERTF3 = 0x00000010;
		public const UInt32 DMC_GETTEXT_OPT1_OWNERPWD5 = 0x00000020;
		public const UInt32 DMC_GETTEXT_OPT1_COMPRESS = 0x00000100;
		public const UInt32 DMC_GETTEXT_OPT1_COMPRESS1 = 0x00000200;
		public const UInt32 DMC_GETTEXT_OPT1_COMPRESS2 = 0x00000400;
		public const UInt32 DMC_GETTEXT_OPT1_COMPRESS3 = 0x00000800;
		public const UInt32 DMC_GETTEXT_OPT1_COMPRESS4 = 0x00001000;
		public const UInt32 DMC_GETTEXT_OPT1_TRACK = 0x00002000;
		public const UInt32 DMC_GETTEXT_OPT1_COMPRESS5 = 0x00004000;
		public const UInt32 DMC_GETTEXT_OPT1_INSERTF4 = 0x00008000;
		public const UInt32 DMC_GETTEXT_OPT1_TXCONV = 0x00010000;
		public const UInt32 DMC_GETTEXT_OPT1_TXCONV2 = 0x00020000;
		public const UInt32 DMC_GETTEXT_OPT1_OUTPUT_RAW_NL = 0x00040000;
		public const UInt32 DMC_GETTEXT_OPT1_QUOTE_QQ = 0x00080000;
		//
		[DllImport("dmcdotnetif.dll")]
		extern static System.IntPtr DMCDOTNET_NewTextInfoV5();
		[DllImport("dmcdotnetif.dll")]
		extern static void DMCDOTNET_DisposeTextInfoV5(System.IntPtr nativeTextInfo);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Ansi)]
		extern static void DMCDOTNET_TextInfoV5_Set_GroupName(System.IntPtr nativeTextInfo, String value);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Ansi)]
		extern static void DMCDOTNET_TextInfoV5_Set_DefLangName(System.IntPtr nativeTextInfo, String value);
		[DllImport("dmcdotnetif.dll")]
		extern static void DMCDOTNET_TextInfoV5_Set_bBigEndian(System.IntPtr nativeTextInfo, Int32 value);
		[DllImport("dmcdotnetif.dll")]
		extern static void DMCDOTNET_TextInfoV5_Set_Option(System.IntPtr nativeTextInfo, UInt32 value);
		[DllImport("dmcdotnetif.dll")]
		extern static void DMCDOTNET_TextInfoV5_Set_Option1(System.IntPtr nativeTextInfo, UInt32 value);
		[DllImport("dmcdotnetif.dll")]
		extern static void DMCDOTNET_TextInfoV5_Set_Size(System.IntPtr nativeTextInfo, Int64 value);
		[DllImport("dmcdotnetif.dll")]
		extern static void DMCDOTNET_TextInfoV5_Set_Csv_c(System.IntPtr nativeTextInfo, Int16 value);
		//
		public System.IntPtr NewNative() {
			return DMCDOTNET_NewTextInfoV5();
		}
		public void DisposeNative(System.IntPtr nativeTextInfo) {
			DMCDOTNET_DisposeTextInfoV5(nativeTextInfo);
		}
		public void CopyToNative(System.IntPtr nativeTextInfo) {
			DMCDOTNET_TextInfoV5_Set_GroupName(nativeTextInfo, GroupName);
			DMCDOTNET_TextInfoV5_Set_DefLangName(nativeTextInfo, DefLangName);
			DMCDOTNET_TextInfoV5_Set_bBigEndian(nativeTextInfo, bBigEndian ? 1 : 0);
			DMCDOTNET_TextInfoV5_Set_Option(nativeTextInfo, Option);
			DMCDOTNET_TextInfoV5_Set_Option1(nativeTextInfo, Option1);
			DMCDOTNET_TextInfoV5_Set_Size(nativeTextInfo, Size);
			DMCDOTNET_TextInfoV5_Set_Csv_c(nativeTextInfo, Csv_c);
		}
	}

	public class FileInfo {
		public String DocFormat = "";
		public String DocSubFormat = "";
		public String DocCountry = "";
		public Int32 ProtectCode = 0;
		public Int32 FileType = 0;
		//
		const int FORMATNAME_SZ = 128;
		const int SUBFORMAT_SZ = 128;
		const int COUNTRYNAME_SZ = 32;
		[DllImport("dmcdotnetif.dll")]
		extern static System.IntPtr DMCDOTNET_NewFileInfo();
		[DllImport("dmcdotnetif.dll")]
		extern static void DMCDOTNET_DisposeFileInfo(System.IntPtr nativeFileInfo);
		[DllImport("dmcdotnetif.dll")]
		extern static void DMCDOTNET_FileInfo_Get_DocFormat(System.IntPtr nativeFileInfo, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll")]
		extern static void DMCDOTNET_FileInfo_Get_DocSubFormat(System.IntPtr nativeFileInfo, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll")]
		extern static void DMCDOTNET_FileInfo_Get_DocCountry(System.IntPtr nativeFileInfo, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll")]
		extern static Int32 DMCDOTNET_FileInfo_Get_ProtectCode(System.IntPtr nativeFileInfo);
		[DllImport("dmcdotnetif.dll")]
		extern static Int32 DMCDOTNET_FileInfo_Get_FileType(System.IntPtr nativeFileInfo);
		//
		public System.IntPtr NewNative() {
			return DMCDOTNET_NewFileInfo();
		}
		public void DisposeNative(System.IntPtr nativeFileInfo) {
			DMCDOTNET_DisposeFileInfo(nativeFileInfo);
		}
		public void CopyFromNative(System.IntPtr nativeFileInfo) {
			var buffer = new StringBuilder(FORMATNAME_SZ);
			buffer.Length = 0;
			DMCDOTNET_FileInfo_Get_DocFormat(nativeFileInfo, buffer, FORMATNAME_SZ);
			DocFormat = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_FileInfo_Get_DocSubFormat(nativeFileInfo, buffer, SUBFORMAT_SZ);
			DocSubFormat = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_FileInfo_Get_DocCountry(nativeFileInfo, buffer, COUNTRYNAME_SZ);
			DocCountry = buffer.ToString();
			ProtectCode = DMCDOTNET_FileInfo_Get_ProtectCode(nativeFileInfo);
			FileType = DMCDOTNET_FileInfo_Get_FileType(nativeFileInfo);
		}
	}

	public class Property {
		public String title = "";
		public String author = "";
		public String keyword = "";
		public String subject = "";
		public String comment = "";
		public String manager = "";
		public String company = "";
		public String category = "";
		public String createdate = "";
		public String revision = "";
		public String lastrevisor = "";
		public String revisioncount = "";
		public String lastprintdate = "";
		public String edittime = "";
		public String creator = "";
		public String producer = "";
		public String encryptionflag = "";
		public String slides = "";
		public String paragraphs = "";
		public String bytes = "";
		public String notes = "";
		public String presentation = "";
		public String doctype = "";
		public String lastsavetime = "";
		public String owner = "";
		public String abstractProp = "";	// abstractは予約語。
		public String account = "";
		public String address = "";
		public String attachments = "";
		public String authorization = "";
		public String bill_to = "";
		public String blind_copy = "";
		public String carbon_copy = "";
		public String checked_by = "";
		public String client = "";
		public String department = "";
		public String descriptive_name = "";
		public String descriptive_type = "";
		public String destination = "";
		public String disposition = "";
		public String division = "";
		public String document_number = "";
		public String editor = "";
		public String forward_to = "";
		public String group = "";
		public String language = "";
		public String mail_stop = "";
		public String matter = "";
		public String office = "";
		public String project = "";
		public String publisher = "";
		public String purpose = "";
		public String received_from = "";
		public String recorded_by = "";
		public String recorded_date = "";
		public String reference = "";
		public String revision_date = "";
		public String revision_notes = "";
		public String section = "";
		public String security = "";
		public String source = "";
		public String status = "";
		public String telephone_number = "";
		public String typist = "";
		public String version_date = "";
		public String version_notes = "";
		public String version_number = "";
		//
		const int MAXPROLEN = 256;
		const int MAXCHARBUF = 4 * MAXPROLEN + 4; 
		const int MAXDATABUF = 256;
		[DllImport("dmcdotnetif.dll")]
		extern static System.IntPtr DMCDOTNET_NewProperty();
		[DllImport("dmcdotnetif.dll")]
		extern static void DMCDOTNET_DisposeProperty(System.IntPtr nativeProperty);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_title(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_author(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_keyword(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_subject(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_comment(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_manager(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_company(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_category(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_createdate(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_revision(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_lastrevisor(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_revisioncount(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_lastprintdate(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_edittime(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_creator(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_producer(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_encryptionflag(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_slides(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_paragraphs(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_bytes(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_notes(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_presentation(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_doctype(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_lastsavetime(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_owner(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_abstract(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_account(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_address(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_attachments(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_authorization(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_bill_to(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_blind_copy(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_carbon_copy(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_checked_by(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_client(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_department(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_descriptive_name(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_descriptive_type(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_destination(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_disposition(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_division(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_document_number(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_editor(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_forward_to(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_group(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_language(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_mail_stop(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_matter(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_office(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_project(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_publisher(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_purpose(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_received_from(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_recorded_by(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_recorded_date(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_reference(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_revision_date(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_revision_notes(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_section(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_security(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_source(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_status(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_telephone_number(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_typist(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_version_date(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_version_notes(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static void DMCDOTNET_Property_Get_version_number(System.IntPtr nativeProperty, StringBuilder buffer, UInt32 bfsz);
		//
		public System.IntPtr NewNative() {
			return DMCDOTNET_NewProperty();
		}
		public void DisposeNative(System.IntPtr nativeProperty) {
			DMCDOTNET_DisposeProperty(nativeProperty);
		}
		public void CopyFromNative(System.IntPtr nativeProperty) {
			var buffer = new StringBuilder(MAXCHARBUF);
			buffer.Length = 0;
			DMCDOTNET_Property_Get_title(nativeProperty, buffer, MAXCHARBUF);
			title = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_author(nativeProperty, buffer, MAXCHARBUF);
			author = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_keyword(nativeProperty, buffer, MAXCHARBUF);
			keyword = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_subject(nativeProperty, buffer, MAXCHARBUF);
			subject = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_comment(nativeProperty, buffer, MAXCHARBUF);
			comment = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_manager(nativeProperty, buffer, MAXCHARBUF);
			manager = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_company(nativeProperty, buffer, MAXCHARBUF);
			company = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_category(nativeProperty, buffer, MAXCHARBUF);
			category = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_createdate(nativeProperty, buffer, MAXDATABUF);
			createdate = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_revision(nativeProperty, buffer, MAXCHARBUF);
			revision = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_lastrevisor(nativeProperty, buffer, MAXCHARBUF);
			lastrevisor = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_revisioncount(nativeProperty, buffer, MAXDATABUF);
			revisioncount = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_lastprintdate(nativeProperty, buffer, MAXDATABUF);
			lastprintdate = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_edittime(nativeProperty, buffer, MAXDATABUF);
			edittime = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_creator(nativeProperty, buffer, MAXCHARBUF);
			creator = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_producer(nativeProperty, buffer, MAXCHARBUF);
			producer = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_encryptionflag(nativeProperty, buffer, 32);
			encryptionflag = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_slides(nativeProperty, buffer, MAXDATABUF);
			slides = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_paragraphs(nativeProperty, buffer, MAXDATABUF);
			paragraphs = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_bytes(nativeProperty, buffer, MAXDATABUF);
			bytes = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_notes(nativeProperty, buffer, MAXDATABUF);
			notes = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_presentation(nativeProperty, buffer, MAXCHARBUF);
			presentation = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_doctype(nativeProperty, buffer, MAXDATABUF);
			doctype = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_lastsavetime(nativeProperty, buffer, MAXDATABUF);
			lastsavetime = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_owner(nativeProperty, buffer, MAXDATABUF);
			owner = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_abstract(nativeProperty, buffer, MAXDATABUF);
			abstractProp = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_account(nativeProperty, buffer, MAXDATABUF);
			account = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_address(nativeProperty, buffer, MAXDATABUF);
			address = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_attachments(nativeProperty, buffer, MAXDATABUF);
			attachments = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_authorization(nativeProperty, buffer, MAXDATABUF);
			authorization = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_bill_to(nativeProperty, buffer, MAXDATABUF);
			bill_to = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_blind_copy(nativeProperty, buffer, MAXDATABUF);
			blind_copy = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_carbon_copy(nativeProperty, buffer, MAXDATABUF);
			carbon_copy = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_checked_by(nativeProperty, buffer, MAXDATABUF);
			checked_by = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_client(nativeProperty, buffer, MAXDATABUF);
			client = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_department(nativeProperty, buffer, MAXDATABUF);
			department = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_descriptive_name(nativeProperty, buffer, MAXDATABUF);
			descriptive_name = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_descriptive_type(nativeProperty, buffer, MAXDATABUF);
			descriptive_type = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_destination(nativeProperty, buffer, MAXDATABUF);
			destination = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_disposition(nativeProperty, buffer, MAXDATABUF);
			disposition = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_division(nativeProperty, buffer, MAXDATABUF);
			division = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_document_number(nativeProperty, buffer, MAXDATABUF);
			document_number = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_editor(nativeProperty, buffer, MAXDATABUF);
			editor = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_forward_to(nativeProperty, buffer, MAXDATABUF);
			forward_to = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_group(nativeProperty, buffer, MAXDATABUF);
			group = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_language(nativeProperty, buffer, MAXDATABUF);
			language = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_mail_stop(nativeProperty, buffer, MAXDATABUF);
			mail_stop = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_matter(nativeProperty, buffer, MAXDATABUF);
			matter = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_office(nativeProperty, buffer, MAXDATABUF);
			office = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_project(nativeProperty, buffer, MAXDATABUF);
			project = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_publisher(nativeProperty, buffer, MAXDATABUF);
			publisher = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_purpose(nativeProperty, buffer, MAXDATABUF);
			purpose = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_received_from(nativeProperty, buffer, MAXDATABUF);
			received_from = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_recorded_by(nativeProperty, buffer, MAXDATABUF);
			recorded_by = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_recorded_date(nativeProperty, buffer, MAXDATABUF);
			recorded_date = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_reference(nativeProperty, buffer, MAXDATABUF);
			reference = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_revision_date(nativeProperty, buffer, MAXDATABUF);
			revision_date = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_revision_notes(nativeProperty, buffer, MAXDATABUF);
			revision_notes = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_section(nativeProperty, buffer, MAXDATABUF);
			section = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_security(nativeProperty, buffer, MAXDATABUF);
			security = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_source(nativeProperty, buffer, MAXDATABUF);
			source = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_status(nativeProperty, buffer, MAXDATABUF);
			status = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_telephone_number(nativeProperty, buffer, MAXDATABUF);
			telephone_number = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_typist(nativeProperty, buffer, MAXDATABUF);
			typist = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_version_date(nativeProperty, buffer, MAXDATABUF);
			version_date = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_version_notes(nativeProperty, buffer, MAXDATABUF);
			version_notes = buffer.ToString();
			buffer.Length = 0;
			DMCDOTNET_Property_Get_version_number(nativeProperty, buffer, MAXDATABUF);
			version_number = buffer.ToString();
		}		
	}

	public class TextPorterV5 {
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static Int32 DMCDOTNET_GetText_V5W(String appFile, String txtFile, System.IntPtr nativeTextInfo);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static Int32 DMCDOTNET_GetFileInfo_V5W(String appFile, System.IntPtr nativeFileInfo, System.IntPtr nativeTextInfo);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static Int32 DMCDOTNET_GetProperty_V5W(String appFile, System.IntPtr nativeTextInfo, System.IntPtr nativeProperty);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static Int32 DMCDOTNET_GetPageText_V5W(String appFile, String txtFile, System.IntPtr nativeTextInfo, ref Int32 pages);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static Int32 DMCDOTNET_GetPwdText_V5W(String appFile, String txtFile, System.IntPtr nativeTextInfo, System.IntPtr nativePassword);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static Int32 DMCDOTNET_GetPwdPageText_V5W(String appFile, String txtFile, System.IntPtr nativeTextInfo, ref Int32 pages, System.IntPtr nativePassword);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static Int32 DMCDOTNET_GetPwdProperty_V5W(String appFile, System.IntPtr nativeTextInfo, System.IntPtr nativeProperty, System.IntPtr nativePassword);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Ansi)]
		extern static System.IntPtr DMCDOTNET_NewPassword(String password);
		[DllImport("dmcdotnetif.dll")]
		extern static void DMCDOTNET_DisposePassword(System.IntPtr nativePassword);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static Int32 DMCDOTNET_GetTextStream_V5W(String appFile, Stream outStream, System.IntPtr nativeTextInfo);
		[DllImport("dmcdotnetif.dll", CharSet = CharSet.Unicode)]
		extern static Int32 DMCDOTNET_GetPageTextStream_V5W(String appFile, Stream outStream, System.IntPtr nativeTextInfo, ref Int32 pages);
		//
		public static Int32 GetText_V5W(String appFile, String txtFile, TextInfoV5 textInfo) {
			var nativeTextInfo = textInfo.NewNative();
			textInfo.CopyToNative(nativeTextInfo);
			var result = DMCDOTNET_GetText_V5W(appFile, txtFile, nativeTextInfo);
			textInfo.DisposeNative(nativeTextInfo);
			return result;
		}
		public static Int32 GetFileInfo_V5W(String appFile, FileInfo fileInfo, TextInfoV5 textInfo) {
			var nativeFileInfo = fileInfo.NewNative();
			var nativeTextInfo = textInfo.NewNative();
			textInfo.CopyToNative(nativeTextInfo);
			var result = DMCDOTNET_GetFileInfo_V5W(appFile, nativeFileInfo, nativeTextInfo);
			fileInfo.CopyFromNative(nativeFileInfo);
			fileInfo.DisposeNative(nativeFileInfo);
			textInfo.DisposeNative(nativeTextInfo);
			return result;
		}
		public static Int32 GetProperty_V5W(String appFile, TextInfoV5 textInfo, Property property) {
			var nativeProperty = property.NewNative();
			var nativeTextInfo = textInfo.NewNative();
			textInfo.CopyToNative(nativeTextInfo);
			var result = DMCDOTNET_GetProperty_V5W(appFile, nativeTextInfo, nativeProperty);
			property.CopyFromNative(nativeProperty);
			property.DisposeNative(nativeProperty);
			textInfo.DisposeNative(nativeTextInfo);
			return result;
		}
		public static Int32 GetPageText_V5W(String appFile, String txtFile, TextInfoV5 textInfo, ref Int32 pages) {
			var nativeTextInfo = textInfo.NewNative();
			textInfo.CopyToNative(nativeTextInfo);
			var result = DMCDOTNET_GetPageText_V5W(appFile, txtFile, nativeTextInfo, ref pages);
			textInfo.DisposeNative(nativeTextInfo);
			return result;
		}
		public static Int32 GetPwdText_V5W(String appFile, String txtFile, TextInfoV5 textInfo, String password) {
			var nativeTextInfo = textInfo.NewNative();
			textInfo.CopyToNative(nativeTextInfo);
			var nativePassword = DMCDOTNET_NewPassword(password);
			var result = DMCDOTNET_GetPwdText_V5W(appFile, txtFile, nativeTextInfo, nativePassword);
			DMCDOTNET_DisposePassword(nativePassword);
			textInfo.DisposeNative(nativeTextInfo);
			return result;
		}
		public static Int32 GetPwdPageText_V5W(String appFile, String txtFile, TextInfoV5 textInfo, ref Int32 pages, String password) {
			var nativeTextInfo = textInfo.NewNative();
			textInfo.CopyToNative(nativeTextInfo);
			var nativePassword = DMCDOTNET_NewPassword(password);
			var result = DMCDOTNET_GetPwdPageText_V5W(appFile, txtFile, nativeTextInfo, ref pages, nativePassword);
			DMCDOTNET_DisposePassword(nativePassword);
			textInfo.DisposeNative(nativeTextInfo);
			return result;
		}
		public static Int32 GetPwdProperty_V5W(String appFile, TextInfoV5 textInfo, Property property, String password) {
			var nativeProperty = property.NewNative();
			var nativeTextInfo = textInfo.NewNative();
			textInfo.CopyToNative(nativeTextInfo);
			var nativePassword = DMCDOTNET_NewPassword(password);
			var result = DMCDOTNET_GetPwdProperty_V5W(appFile, nativeTextInfo, nativeProperty, nativePassword);
			DMCDOTNET_DisposePassword(nativePassword);
			property.CopyFromNative(nativeProperty);
			property.DisposeNative(nativeProperty);
			textInfo.DisposeNative(nativeTextInfo);
			return result;
		}
		public static Int32 GetTextStream_V5W(String appFile, Stream outStream, TextInfoV5 textInfo) {
			var nativeTextInfo = textInfo.NewNative();
			textInfo.CopyToNative(nativeTextInfo);
			var result = DMCDOTNET_GetTextStream_V5W(appFile, outStream, nativeTextInfo);
			textInfo.DisposeNative(nativeTextInfo);
			return result;
		}
		public static Int32 GetPageTextStream_V5W(String appFile, Stream outStream, TextInfoV5 textInfo, ref Int32 pages) {
			var nativeTextInfo = textInfo.NewNative();
			textInfo.CopyToNative(nativeTextInfo);
			var result = DMCDOTNET_GetPageTextStream_V5W(appFile, outStream, nativeTextInfo, ref pages);
			textInfo.DisposeNative(nativeTextInfo);
			return result;
		}
	}
}
