/**
 *
 * Copyright 2003 Antenna House Inc.
 * Author: Zhu YaoBing
 *
 */

import java.io.*;

import jp.co.antenna.dmc.v5.*;
import jp.co.antenna.dmc.v4.*;

/**
 * Test
 * @author Zhu YaoBing
 * 
 */
 
class CMDInfo {

	private static int   nFileCount;
	private static int   nFilePos;
	private static String sDstDir;//0x00000001 tag
	private static String txtfile;//0x00000002 tag
	private static String GroupName;//0x00000004 tag
	private static String DefLangName;//0x00000008 tag
	private static int bBigEndian;//0x00000010 tag
	private static long Option;//0x00000020 tag
	private static long Option1;//0x00000040 tag
	private static int nFunc;//0x00000080 tag
	private static int pages;//0x00000100 tag
	private static String password;//0x00000200 tag
	private static boolean bOU;
	private static long size;//0x00000400 tag
	private static int  Csv_c;//0x00000800 tag
	private static boolean bMultiThread;//0x00001000 tag
	private static long Tag;

	// function number definitions
	// 2007/11/20 by show
	public final static int FT_GET_TEXT_V5 = 0;
	public final static int FT_GET_PAGE_TEXT_V5 = 1;
	public final static int FT_GET_PROPERTY_V5 = 2;
	public final static int FT_GET_PWD_TEXT_V5 = 3;
	public final static int FT_GET_PWD_PAGE_TEXT_V5 = 4;
	public final static int FT_GET_PWD_PROPERTY_V5 = 5;
	public final static int FT_GET_TEXT_STREAM_V5 = 6;
	public final static int FT_GET_PAGE_TEXT_STREAM_V5 = 7;
	public final static int FT_GET_TEXT_V4 = 8;
	public final static int FT_GET_PAGE_TEXT_V4 = 9;
	public final static int FT_GET_PROPERTY_V4 = 10;
	public final static int FT_GET_PWD_TEXT_V4 = 11;
	public final static int FT_GET_PWD_PAGE_TEXT_V4 = 12;
	public final static int FT_GET_PWD_PROPERTY_V4 = 13;
	public final static int FT_GET_TEXT_STREAM_V4 = 14;
	public final static int FT_GET_PAGE_TEXT_STREAM_V4 = 15;
	public final static int FT_GET_TEXT_V5W = 16;
	public final static int FT_GET_PAGE_TEXT_V5W = 17;
	public final static int FT_GET_PROPERTY_V5W = 18;
	public final static int FT_GET_PWD_TEXT_V5W = 19;
	public final static int FT_GET_PWD_PAGE_TEXT_V5W = 20;
	public final static int FT_GET_PWD_PROPERTY_V5W = 21;
	public final static int FT_GET_TEXT_STREAM_V5W = 22;
	public final static int FT_GET_PAGE_TEXT_STREAM_V5W = 23;

	public CMDInfo(){
	}
	
	public static void SetnFileCount(){
		nFileCount=nFileCount+1;
	}
	public static int GetnFileCount(){
		return nFileCount;
	}
	public static void SetnFilePos(int I){
		nFilePos=I;
	}
	public static int GetnFilePos(){
		return nFilePos;
	}
	public static void SetsDstDir(String S){
		if((Tag&0x00000001)==0){
			sDstDir=new String(S);
			Tag=Tag|0x00000001; 
		}
	}
	public static String GetsDstDir(){
		if((Tag&0x00000001)!=0){
			return sDstDir;
		}
		else{
			sDstDir="";
			return sDstDir;
		}
	}
	public static void Settxtfile(String S){
		if((Tag&0x00000002)==0){
			txtfile=new String(S);
			Tag=Tag|0x00000002;
		}
	}
	public static String Gettxtfile(){
		if((Tag&0x00000002)!=0){
			return txtfile;
		}
		else{
			txtfile="";
			return txtfile;
		}
	}
	public static void SetGroupName(String S){
		if((Tag&0x00000004)==0){
			GroupName=new String(S);
			Tag=Tag|0x00000004;
		}
	}
	public static String GetGroupName(){
		if((Tag&0x00000004)!=0){
			return GroupName;
		}
		else{
			GroupName="Shift_JIS";
			return GroupName;
		}
	}
	public static void SetDefLangName(String S){
		if((Tag&0x00000008)==0){
			DefLangName=new String(S);
			Tag=Tag|0x00000008;
		}
	}
	public static String GetDefLangName(){
		if((Tag&0x00000008)!=0){
			return DefLangName;
		}
		else{
			DefLangName="Japanese";
			return DefLangName;
		}
	}
	public static void SetbBigEndian(int I){
		bBigEndian=I;
		Tag=Tag|0x00000010;
	}
	public static int GetbBigEndian(){
		if((Tag&0x00000010)!=0){
			return bBigEndian;
		}
		else{
			return 1;
		}
	}
	public static void SetbMultiThread(boolean b){
		bMultiThread=b;
		Tag=Tag|0x00001000;
	}
	public static boolean GetbMultiThread(){
		if((Tag&0x00001000)!=0){
			return bMultiThread;
		}
		else{
			return false;
		}
	}
	public static void SetOption(long L){
		Option=Option|L;
		Tag=Tag|0x00000020;
	}
	public static long GetOption(){
		if((Option&0x00000010)==0
		  &&(Option&0x00000020)==0
		  &&(Option&0x00000040)==0
		  &&(Option&0x00000080)==0){
		  Option=Option|0x00000008;	
		}
		return Option;
	}
	public static void SetOption1(long L){
		Option1=Option1|L;
		Tag=Tag|0x00000040;
	}
	public static long GetOption1(){
		return Option1;
	}
	public static void SetnFunc(int I){
		nFunc=I;
		Tag=Tag|0x00000080;
	}
	public static int GetnFunc(){
		if((Tag&0x00000080)!=0){
			return nFunc;
		}
		else{
			return 0;
		}
	}
	public static void Setpages(int I){
		pages=I;
		Tag=Tag|0x00000100;
	}
	public static int Getpages(){
		if((Tag&0x00000100)!=0){
			return pages;
		}
		else{
			return 0;
		}
	}
	public static void Setpassword(String S){
		if((Tag&0x00000200)==0){
			password=new String(S);
			Tag=Tag|0x00000200; 
		}
	}
	public static String Getpassword(){
		if((Tag&0x00000200)!=0){
			return password;
		}
		else{
			password="";
			return password;
		}
	}
	public static void SetbOU(boolean b){
		bOU=b;
	}
	public static boolean GetbOU(){
		return bOU;
	}
	public static void Setsize(long L){
		size=L;
		Tag=Tag|0x00000400;
	}
	public static long Getsize(){
		if((Tag&0x00000400)!=0){
			return size;
		}
		else{
			return 0;
		}
	}
	public static void SetCsv_c(int I){
		Csv_c=I;
		Tag=Tag|0x00000800;
	}
	public static int GetCsv_c(){
		return Csv_c;
	}
}

public class Test {
	/*
		GroupNames
			Shift_JIS-2004
			ISO-2022-JP-2004
			EUC-JIS-2004
		and notes (V4 must use XXX) for 
			ChineseBIG5(V4 must use Big5)
			ChineseGBK(V4 must use GBK)
			KoreanKSC(V4 must use KS_C_5601-1987)
		were added.
		2007/11/20 by show
	*/
	/*
		function numbers were modified to be V4 functions first.
		2007/11/20 by show
	*/
	/*
		description about bMultithread
			"bMultithread:    0: single thread test(default)\n"+
			"                 1: multi-thread test\n"+
		was removed.
		Because this program does not support to run in multi thread mode.
		2007/11/20 by show
	*/
	private final static String usage="Usage:appfile [-o txtfile] [-t target dir] [-g GroupName] [-e bBigEndian] [-d DefLangName] [-p Option] [-n Pages] [-f function number] [-w password] [-s size] [-c Csv_c]\n"+
		"DefLangName:     en\n"+
		"                 jp(default)\n"+
		"                 cn\n"+
		"                 tw\n"+
		"                 ko\n"+
		"GroupName:       EUC-JP\n"+
		"                 EUC-JP-FIX\n"+
		"                 ISO-10646-UCS-2\n"+
		"                 ISO-10646-UCS-4\n"+
		"                 ISO-2022-JP\n"+
		"                 ISO8859-1\n"+
		"                 Shift_JIS(default)\n"+
		"                 UTF-16\n"+
		"                 UTF-8\n"+
		"                 WINDOWS31J\n"+
		"                 ChineseBIG5(V4 must use Big5)\n"+
		"                 ChineseGBK(V4 must use GBK)\n"+
		"                 ChineseGB18030\n"+
		"                 KoreanKSC(V4 must use KS_C_5601-1987)\n"+
		"                 Shift_JIS-2004\n"+
		"                 ISO-2022-JP-2004\n"+
		"                 EUC-JIS-2004\n"+
		"bBigEndian:      0: little endian\n"+
		"                 1: big endian(default)\n"+
		"Option:          DMC_GETTEXT_OPT_KEISEN\n"+
		"                 DMC_GETTEXT_OPT_TAG\n"+
		"                 DMC_GETTEXT_OPT_CRLF(default)\n"+
		"                 DMC_GETTEXT_OPT_CR\n"+
		"                 DMC_GETTEXT_OPT_LF\n"+
		"                 DMC_GETTEXT_OPT_U2028\n"+
		"                 DMC_GETTEXT_OPT_U2029\n"+
		"                 DMC_GETTEXT_OPT_SHEET\n"+
		"                 DMC_GETTEXT_OPT_RUBI\n"+
		"                 DMC_GETTEXT_OPT_PWD\n"+
		"                 DMC_GETTEXT_OPT_OLE\n"+
		"                 DMC_GETTEXT_OPT_OLE1\n"+
		"                 DMC_GETTEXT_OPT_OLE2\n"+
		"                 DMC_GETTEXT_OPT_OLE3\n"+
		"                 DMC_GETTEXT_OPT_OUT\n"+
		"                 DMC_GETTEXT_OPT_LOOP\n"+
		"                 DMC_GETTEXT_OPT_SHEET1\n"+
		"                 DMC_GETTEXT_OPT_CELL\n"+
		"                 DMC_GETTEXT_OPT_SIZE\n"+
		"                 DMC_GETTEXT_OPT_CSV1\n"+
		"                 DMC_GETTEXT_OPT_CSV2\n"+
		"                 DMC_GETTEXT_OPT_PDFSYM\n"+
		"                 DMC_GETTEXT_OPT_OWNERPWD1\n"+
		"                 DMC_GETTEXT_OPT_OWNERPWD2\n"+
		"                 DMC_GETTEXT_OPT_OWNERPWD3\n"+
		"                 DMC_GETTEXT_OPT_OWNERPWD4\n"+
		"                 DMC_GETTEXT_OPT1_OWNERPWD5\n"+
		"                 DMC_GETTEXT_OPT_ENDCODE\n"+
		"                 DMC_GETTEXT_OPT_NULL\n"+
		"                 DMC_GETTEXT_OPT_SHFTAG\n"+
		"                 DMC_GETTEXT_OPT_SHFHEAD\n"+
		"                 DMC_GETTEXT_OPT1_TEMP\n"+
		"                 DMC_GETTEXT_OPT1_INSERTF\n"+
		"                 DMC_GETTEXT_OPT1_INSERTF1\n"+
		"                 DMC_GETTEXT_OPT1_INSERTF2\n"+
		"                 DMC_GETTEXT_OPT1_INSERTF3\n"+
		"                 DMC_GETTEXT_OPT1_COMPRESS\n"+
		"                 DMC_GETTEXT_OPT1_COMPRESS1\n"+
		"                 DMC_GETTEXT_OPT1_COMPRESS2\n"+
		"                 DMC_GETTEXT_OPT1_COMPRESS3\n"+
		"                 DMC_GETTEXT_OPT1_COMPRESS4\n"+
		"                 DMC_GETTEXT_OPT1_TRACK\n"+
		"                 DMC_GETTEXT_OPT1_COMPRESS5\n"+
	    "                 DMC_GETTEXT_OPT1_INSERTF4\n"+
	    "                 DMC_GETTEXT_OPT1_TXCONV\n"+
	    "                 DMC_GETTEXT_OPT1_TXCONV2\n"+
		"Pages:           0: get page count(default)\n"+
		"                 1,2,3...: page number\n"+
		"function number: 0: test DMC_GetText_V5(default)\n"+
		"                 1: test DMC_GetPageText_V5\n"+
		"                 2: test DMC_GetProperty_V5\n"+
		"                 3: test DMC_GetPwdText_V5\n"+
		"                 4: test DMC_GetPwdPageText_V5\n"+
		"                 5: test DMC_GetPwdProperty_V5\n"+
		"                 6: test DMC_GetTextStream_V5\n"+
	    "                 7: test DMC_GetPageTextStream_V5\n"+
		"                 8: test DMC_GetText_V4\n"+
		"                 9: test DMC_GetPageText_V4\n"+
		"                10: test DMC_GetProperty_V4\n"+
		"                11: test DMC_GetPwdText_V4\n"+
		"                12: test DMC_GetPwdPageText_V4\n"+
		"                13: test DMC_GetPwdProperty_V4\n"+
		"                14: test DMC_GetTextStream_V4\n"+
	    "                15: test DMC_GetPageTextStream_V4\n"+
		"                16: test DMC_GetText_V5W\n"+
		"                17: test DMC_GetPageText_V5W\n"+
		"                18: test DMC_GetProperty_V5W\n"+
		"                19: test DMC_GetPwdText_V5W\n"+
		"                20: test DMC_GetPwdPageText_V5W\n"+
		"                21: test DMC_GetPwdProperty_V5W\n"+
		"                22: test DMC_GetTextStream_V5W\n"+
	    "                23: test DMC_GetPageTextStream_V5W\n";

	private static void WriteUsage(){
	    System.err.println(usage);
		System.exit(1);
    }

	private static boolean GetcfOpt(CMDInfo cinfo,String pCmd){
		if(pCmd.equals("DMC_GETTEXT_OPT_KEISEN")){
			cinfo.SetOption(0x00000001);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_TAG")){
			cinfo.SetOption(0x00000002);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_RUBI")){
			cinfo.SetOption(0x00000004);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_CRLF")){
			cinfo.SetOption(0x00000008);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_CR")){
			cinfo.SetOption(0x00000010);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_LF")){
			cinfo.SetOption(0x00000020);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_U2028")){
			cinfo.SetOption(0x00000040);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_U2029")){
			cinfo.SetOption(0x00000080);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_SHEET")){
			cinfo.SetOption(0x00000100);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_PWD")){
			cinfo.SetOption(0x00000400);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_OLE")){
			cinfo.SetOption(0x00001000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_OLE1")){
			cinfo.SetOption(0x00002000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_OLE2")){
			cinfo.SetOption(0x00004000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_OLE3")){
			cinfo.SetOption(0x00008000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_OUT")){
			cinfo.SetOption(0x00010000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_LOOP")){
			cinfo.SetOption(0x00020000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_SHFTAG")){
			cinfo.SetOption(0x00040000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_SHFHEAD")){
			cinfo.SetOption(0x00080000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_SHEET1")){
			cinfo.SetOption(0x00100000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_CELL")){
			cinfo.SetOption(0x00200000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_SIZE")){
			cinfo.SetOption(0x00400000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_PDFSYM")){
			cinfo.SetOption(0x00800000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_CSV1")){
			cinfo.SetOption(0x01000000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_CSV2")){
			cinfo.SetOption(0x02000000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_ENDCODE")){
			cinfo.SetOption(0x04000000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_NULL")){
			cinfo.SetOption(0x08000000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_OWNERPWD1")){
			cinfo.SetOption(0x10000000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_OWNERPWD2")){
			cinfo.SetOption(0x20000000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_OWNERPWD3")){
			cinfo.SetOption(0x40000000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT_OWNERPWD4")){
			cinfo.SetOption(0x80000000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT1_TEMP")){
			cinfo.SetOption1(0x00000001);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT1_INSERTF")){
			cinfo.SetOption1(0x00000002);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT1_INSERTF1")){
			cinfo.SetOption1(0x00000004);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT1_INSERTF2")){
			cinfo.SetOption1(0x00000008);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT1_INSERTF3")){
			cinfo.SetOption1(0x00000010);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT1_OWNERPWD5")){
			cinfo.SetOption1(0x00000020);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT1_COMPRESS")){
			cinfo.SetOption1(0x00000100);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT1_COMPRESS1")){
			cinfo.SetOption1(0x00000200);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT1_COMPRESS2")){
			cinfo.SetOption1(0x00000400);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT1_COMPRESS3")){
			cinfo.SetOption1(0x00000800);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT1_COMPRESS4")){
			cinfo.SetOption1(0x00001000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT1_TRACK")){
			cinfo.SetOption1(0x00002000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT1_COMPRESS5")){
			cinfo.SetOption1(0x00004000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT1_INSERTF4")){
			cinfo.SetOption1(0x00008000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT1_TXCONV")){
			cinfo.SetOption1(0x00010000);
			return true;
		}
		else if(pCmd.equals("DMC_GETTEXT_OPT1_TXCONV2")){
			cinfo.SetOption1(0x00020000);
			return true;
		}
		else{
			return false;
		}
	}

	private static boolean ParseCmdLine(String[] args,CMDInfo cinfo){
		int i;
		
		if(args.length<1) {
			return false;
	    }
	 	for( i=0; i<args.length; i++ ){
	 		switch(args[i].charAt(0)){
	 			case '-':
					if(args[i].length()<2){
						return false;
					}
					if(args[i].length()==2&&i>args.length-2){
						return false;
					}
					if(args[i].length()==2&&args[i+1].charAt(0)=='-'){
						return false;
					}
					switch(args[i].charAt(1)){
						case 't':
						case 'T':
							if(args[i].length()==2){
								cinfo.SetsDstDir(args[i+1]);
							}
							else{
								cinfo.SetsDstDir(args[i].substring(2));
							}
							break;
						case 'o':
						case 'O':
							if(args[i].length()==2){
								cinfo.Settxtfile(args[i+1]);
							}
							else{
								cinfo.Settxtfile(args[i].substring(2));
							}
							cinfo.SetbOU(true);
							break;
						case 'g':
						case 'G':
							if(args[i].length()==2){
								cinfo.SetGroupName(args[i+1]);
							}
							else{
								cinfo.SetGroupName(args[i].substring(2));
							}
							break;
						case 'w':
						case 'W':
							if(args[i].length()==2){
								cinfo.Setpassword(args[i+1]);
							}
							else{
								cinfo.Setpassword(args[i].substring(2));
							}
							break;
						case 'd':
						case 'D':
							if(args[i].length()==2){
								cinfo.SetDefLangName(args[i+1]);
							}
							else{
								cinfo.SetDefLangName(args[i].substring(2));
							}
							break;
						case 'e':
						case 'E':
							if(args[i].length()==2){
								if(args[i+1].length()>1){
									return false;
								}
								switch(args[i+1].charAt(0)){
								case '0':
									cinfo.SetbBigEndian(0);
									break;
								case '1':
									cinfo.SetbBigEndian(1);
									break;
								default:
									return false;
								}
							}
							else{
								if((args[i].length()-2)>1 ){
									return false;
								}
								switch((args[i].substring(2)).charAt(0)){
									case '0':
										cinfo.SetbBigEndian(0);
										break;
									case '1':
										cinfo.SetbBigEndian(1);
										break;
									default:
										return false;
								}
							}
							break;
						case 'p':
						case 'P':
							if(args[i].length()==2){
								if(!GetcfOpt(cinfo,args[i+1])){
									return false;
								}
							}
							else {
								if(!GetcfOpt(cinfo,args[i].substring(2))){
									return false;
								}
							}
							break;
						case 'f':
						case 'F':
							if(args[i].length()==2){
								if(args[i+1].length()==1){
									switch(args[i+1].charAt(0)){
										case '0':
										case '1':
										case '2':
										case '3':
										case '4':
										case '5':
										case '6':
										case '7':
										case '8':
										case '9':
											cinfo.SetnFunc(Integer.parseInt(args[i+1]));
											break;
										default:
											return false;
									}
								}
								else if(args[i+1].length()==2){
									switch(args[i+1].charAt(0)){
										case '1':
											switch(args[i+1].charAt(1)){
												case '0':
												case '1':
												case '2':
												case '3':
												case '4':
												case '5':
												case '6':
												case '7':
												case '8':
												case '9':
													break;
												default:
													return false;
											}
											cinfo.SetnFunc(Integer.parseInt(args[i+1]));
											break;
										case '2':
											switch(args[i+1].charAt(1)){
												case '0':
												case '1':
												case '2':
												case '3':
													break;
												default:
													return false;
											}
											cinfo.SetnFunc(Integer.parseInt(args[i+1]));
											break;
										default:
											return false;
									}
							    }
							}
							else {
								if((args[i].substring(2)).length()==1 ){
									switch((args[i].substring(2)).charAt(0)){
									case '0':
									case '1':
									case '2':
									case '3':
									case '4':
									case '5':
									case '6':
									case '7':
									case '8':
									case '9':
										cinfo.SetnFunc(Integer.parseInt(args[i].substring(2)));
										break;
									default:
										return false;
								}
							}
							else if((args[i].substring(2)).length()==2){
								switch((args[i].substring(2)).charAt(0)){
									case '1':
									switch((args[i].substring(2)).charAt(1)){
									case '0':
									case '1':
									case '2':
									case '3':
										break;
									default:
										return false;
									}
									cinfo.SetnFunc(Integer.parseInt(args[i].substring(2)));
											break;
								 default:
									 return false;
								 }
							 }
						}
							break;
						case 'n':
						case 'N':
							if(args[i].length()==2){
								cinfo.Setpages(Integer.parseInt(args[i+1]));
							}
							else {
								cinfo.Setpages(Integer.parseInt(args[i].substring(2)));
							}
							break;
						case 's':
						case 'S':
							if(args[i].length()==2){
								cinfo.Setsize(Long.parseLong(args[i+1]));
							}
							else {
								cinfo.Setsize(Long.parseLong(args[i].substring(2)));
							}
							break;
						case 'c':
						case 'C':
							if(args[i].length()==2){
								cinfo.SetCsv_c(Integer.parseInt(args[i+1]));
							}
							else {
								cinfo.SetCsv_c(Integer.parseInt(args[i].substring(2)));
							}
							break;
						case 'm':
						case 'M':
							if(args[i].length()==2){
								if(args[i+1].length()>1){
									return false;
								}
								switch(args[i+1].charAt(0)){
								case '0':
									cinfo.SetbMultiThread(false);
									break;
								case '1':
									cinfo.SetbMultiThread(true);
									break;
								default:
									return false;
								}
							}
							else{
								if((args[i].length()-2)>1 ){
									return false;
								}
								switch((args[i].substring(2)).charAt(0)){
									case '0':
										cinfo.SetbMultiThread(false);
										break;
									case '1':
										cinfo.SetbMultiThread(true);
										break;
									default:
										return false;
								}
							}
							break;
						default:
					        return false;
					}
					if(args[i].length()==2){
						 i++;
					}
	 				break;
	 			default:
	 				if(cinfo.GetnFileCount()==0){
	 					 cinfo.SetnFilePos(i);
	 				}
					if(i>cinfo.GetnFilePos()+cinfo.GetnFileCount()){
						return false;
					}
					cinfo.SetnFileCount();
	 		}
	 	}
	 	if(cinfo.GetnFileCount()==0){
			return false;
		}
		return true;	
	}

	private static void GetTextInfoV5(DMCTextInfoV5 info,CMDInfo cinfo){
		if(cinfo.GetnFunc()==CMDInfo.FT_GET_PROPERTY_V5 || cinfo.GetnFunc()==CMDInfo.FT_GET_PWD_PROPERTY_V5){
			info.setGroupName("UTF-8");
			System.out.println("\nGroupName: "+"UTF-8");
		}
		else{
			info.setGroupName(cinfo.GetGroupName());
			System.out.println("\nGroupName: "+cinfo.GetGroupName());
		}

		info.setDefLangName(cinfo.GetDefLangName());
		System.out.println("DefLangName: "+cinfo.GetDefLangName());

		info.setbBigEndian(cinfo.GetbBigEndian());
		System.out.println("bBigEndian: "+cinfo.GetbBigEndian());

		info.setOption(cinfo.GetOption());
		System.out.println("Option: "+cinfo.GetOption());

		info.setOption1(cinfo.GetOption1());
		System.out.println("Option1: "+cinfo.GetOption1());

		info.setSize(cinfo.Getsize());
		System.out.println("Size: "+cinfo.Getsize());

		info.setCsv_c(cinfo.GetCsv_c());
		System.out.println("Csv_c: "+cinfo.GetCsv_c());

		if(cinfo.GetnFunc() == CMDInfo.FT_GET_PAGE_TEXT_V5){
			System.out.println("Pages: "+cinfo.Getpages());
		}
	}

	private static void GetTextInfoV4(DMCTextInfoV4 info,CMDInfo cinfo){
		if(cinfo.GetnFunc()==CMDInfo.FT_GET_PROPERTY_V4 || cinfo.GetnFunc()==CMDInfo.FT_GET_PWD_PROPERTY_V4){
			info.getGroupName("UTF-8");
			System.out.println("\nGroupName: "+"UTF-8");
		}
		else{
			info.getGroupName(cinfo.GetGroupName());
			System.out.println("\nGroupName: "+cinfo.GetGroupName());
		}

		info.getDefLangName(cinfo.GetDefLangName());
		System.out.println("DefLangName: "+cinfo.GetDefLangName());

		info.getbBigEndian(cinfo.GetbBigEndian());
		System.out.println("bBigEndian: "+cinfo.GetbBigEndian());

		info.getOption(cinfo.GetOption());
		System.out.println("Option: "+cinfo.GetOption());

		info.getOption1(cinfo.GetOption1());
		System.out.println("Option1: "+cinfo.GetOption1());

		info.getSize(cinfo.Getsize());
		System.out.println("Size: "+cinfo.Getsize());

		info.getCsv_c(cinfo.GetCsv_c());
		System.out.println("Csv_c: "+cinfo.GetCsv_c());

		if( cinfo.GetnFunc() == CMDInfo.FT_GET_PAGE_TEXT_V4){
			System.out.println("Pages: "+cinfo.Getpages());
		}
	}

	private static int WritePropToFile(DMCPropertyV5 prop,File txt){
		if(txt.exists()){
			System.out.println("The File "+txt.getPath()+" exist");
			System.out.println("So delete And Rewrite a New "+txt.getPath()+" File");
	       	txt.delete();
	    }
		try{
			BufferedWriter tout = 
               new BufferedWriter(new FileWriter(txt.getPath()));
            
            if(prop.getTitle().length()!=0){
            	tout.write(prop.getTitle());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	              
	     	if(prop.getAuthor().length()!=0){
	        	tout.write(prop.getAuthor());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getKeyword().length()!=0){
	        	tout.write(prop.getKeyword());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getSubject().length()!=0){
	        	tout.write(prop.getSubject());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getComment().length()!=0){
	        	tout.write(prop.getComment());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getManager().length()!=0){
	        	tout.write(prop.getManager());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getCompany().length()!=0){
	        	tout.write(prop.getCompany());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getCategory().length()!=0){
	        	tout.write(prop.getCategory());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getCreatedate().length()!=0){
	        	tout.write(prop.getCreatedate());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getRevision().length()!=0){
	        	tout.write(prop.getRevision());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getLastrevisor().length()!=0){
	        	tout.write(prop.getLastrevisor());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getRevisioncount().length()!=0){
	        	tout.write(prop.getRevisioncount());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getLastprintdate().length()!=0){
	        	tout.write(prop.getLastprintdate());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getEdittime().length()!=0){
	        	tout.write(prop.getEdittime());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getCreator().length()!=0){
	        	tout.write(prop.getCreator());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getProducer().length()!=0){
	        	tout.write(prop.getProducer());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getEncryptionflag().length()!=0){
	        	tout.write(prop.getEncryptionflag());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getSlides().length()!=0){
	        	tout.write(prop.getSlides());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getParagraphs().length()!=0){
	        	tout.write(prop.getParagraphs());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getBytes().length()!=0){
	        	tout.write(prop.getBytes());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getNotes().length()!=0){
	        	tout.write(prop.getNotes());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getPresentation().length()!=0){
	        	tout.write(prop.getPresentation());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getDoctype().length()!=0){
	        	tout.write(prop.getDoctype());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getLastsavetime().length()!=0){
	        	tout.write(prop.getLastsavetime());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getOwner().length()!=0){
	        	tout.write(prop.getOwner());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getAbstract().length()!=0){
	        	tout.write(prop.getAbstract());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getAccount().length()!=0){
	        	tout.write(prop.getAccount());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getAddress().length()!=0){
	        	tout.write(prop.getAddress());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getAttachments().length()!=0){
	        	tout.write(prop.getAttachments());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getAuthorization().length()!=0){
	        	tout.write(prop.getAuthorization());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getBill_to().length()!=0){
	        	tout.write(prop.getBill_to());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getBlind_copy().length()!=0){
	        	tout.write(prop.getBlind_copy());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getCarbon_copy().length()!=0){
	        	tout.write(prop.getCarbon_copy());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getChecked_by().length()!=0){
	        	tout.write(prop.getChecked_by());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getClient().length()!=0){
	        	tout.write(prop.getClient());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getDepartment().length()!=0){
	        	tout.write(prop.getDepartment());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getDescriptive_name().length()!=0){
	        	tout.write(prop.getDescriptive_name());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getDescriptive_type().length()!=0){
	        	tout.write(prop.getDescriptive_type());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getDestination().length()!=0){
	        	tout.write(prop.getDestination());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getDisposition().length()!=0){
	        	tout.write(prop.getDisposition());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getDivision().length()!=0){
	        	tout.write(prop.getDivision());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getDocument_number().length()!=0){
	        	tout.write(prop.getDocument_number());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getEditor().length()!=0){
	        	tout.write(prop.getEditor());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getForward_to().length()!=0){
	        	tout.write(prop.getForward_to());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getGroup().length()!=0){
	        	tout.write(prop.getGroup());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getLanguage().length()!=0){
	        	tout.write(prop.getLanguage());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getMail_stop().length()!=0){
	        	tout.write(prop.getMail_stop());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getMatter().length()!=0){
	        	tout.write(prop.getMatter());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getOffice().length()!=0){
	        	tout.write(prop.getOffice());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getProject().length()!=0){
	        	tout.write(prop.getProject());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getPublisher().length()!=0){
	        	tout.write(prop.getPublisher());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getPurpose().length()!=0){
	        	tout.write(prop.getPurpose());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getReceived_from().length()!=0){
	        	tout.write(prop.getReceived_from());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getRecorded_by().length()!=0){
	        	tout.write(prop.getRecorded_by());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getRecorded_date().length()!=0){
	        	tout.write(prop.getRecorded_date());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getReference().length()!=0){
	        	tout.write(prop.getReference());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getRevision_date().length()!=0){
	        	tout.write(prop.getRevision_date());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getRevision_notes().length()!=0){
	        	tout.write(prop.getRevision_notes());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getSection().length()!=0){
	        	tout.write(prop.getSection());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getSecurity().length()!=0){
	        	tout.write(prop.getSecurity());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getSource().length()!=0){
	        	tout.write(prop.getSource());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getStatus().length()!=0){
	        	tout.write(prop.getStatus());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getTelephone_number().length()!=0){
	        	tout.write(prop.getTelephone_number());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getTypist().length()!=0){
	        	tout.write(prop.getTypist());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getVersion_date().length()!=0){
	        	tout.write(prop.getVersion_date());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getVersion_notes().length()!=0){
	        	tout.write(prop.getVersion_notes());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getVersion_number().length()!=0){
	        	tout.write(prop.getVersion_number());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	        tout.flush();
            tout.close();
       }catch(IOException e){
       	    e.printStackTrace();
       		System.err.println("The System Error");
	        return 0;
       }
		return 1;
	}


	private static int WritePropToFile(DMCPropertyV4 prop,File txt){
		if(txt.exists()){
			System.out.println("The File "+txt.getPath()+" exist");
			System.out.println("So delete And Rewrite a New "+txt.getPath()+" File");
	       	txt.delete();
	    }
		try{
			BufferedWriter tout = 
               new BufferedWriter(new FileWriter(txt.getPath()));
            
            if(prop.getTitle().length()!=0){
            	tout.write(prop.getTitle());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	              
	     	if(prop.getAuthor().length()!=0){
	        	tout.write(prop.getAuthor());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getKeyword().length()!=0){
	        	tout.write(prop.getKeyword());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getSubject().length()!=0){
	        	tout.write(prop.getSubject());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getComment().length()!=0){
	        	tout.write(prop.getComment());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getManager().length()!=0){
	        	tout.write(prop.getManager());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getCompany().length()!=0){
	        	tout.write(prop.getCompany());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getCategory().length()!=0){
	        	tout.write(prop.getCategory());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getCreatedate().length()!=0){
	        	tout.write(prop.getCreatedate());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getRevision().length()!=0){
	        	tout.write(prop.getRevision());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getLastrevisor().length()!=0){
	        	tout.write(prop.getLastrevisor());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getRevisioncount().length()!=0){
	        	tout.write(prop.getRevisioncount());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getLastprintdate().length()!=0){
	        	tout.write(prop.getLastprintdate());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getEdittime().length()!=0){
	        	tout.write(prop.getEdittime());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getCreator().length()!=0){
	        	tout.write(prop.getCreator());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getProducer().length()!=0){
	        	tout.write(prop.getProducer());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getEncryptionflag().length()!=0){
	        	tout.write(prop.getEncryptionflag());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getSlides().length()!=0){
	        	tout.write(prop.getSlides());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getParagraphs().length()!=0){
	        	tout.write(prop.getParagraphs());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getBytes().length()!=0){
	        	tout.write(prop.getBytes());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getNotes().length()!=0){
	        	tout.write(prop.getNotes());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getPresentation().length()!=0){
	        	tout.write(prop.getPresentation());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getDoctype().length()!=0){
	        	tout.write(prop.getDoctype());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getLastsavetime().length()!=0){
	        	tout.write(prop.getLastsavetime());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getOwner().length()!=0){
	        	tout.write(prop.getOwner());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getAbstract().length()!=0){
	        	tout.write(prop.getAbstract());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getAccount().length()!=0){
	        	tout.write(prop.getAccount());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getAddress().length()!=0){
	        	tout.write(prop.getAddress());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getAttachments().length()!=0){
	        	tout.write(prop.getAttachments());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getAuthorization().length()!=0){
	        	tout.write(prop.getAuthorization());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getBill_to().length()!=0){
	        	tout.write(prop.getBill_to());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getBlind_copy().length()!=0){
	        	tout.write(prop.getBlind_copy());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getCarbon_copy().length()!=0){
	        	tout.write(prop.getCarbon_copy());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getChecked_by().length()!=0){
	        	tout.write(prop.getChecked_by());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getClient().length()!=0){
	        	tout.write(prop.getClient());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getDepartment().length()!=0){
	        	tout.write(prop.getDepartment());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getDescriptive_name().length()!=0){
	        	tout.write(prop.getDescriptive_name());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getDescriptive_type().length()!=0){
	        	tout.write(prop.getDescriptive_type());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getDestination().length()!=0){
	        	tout.write(prop.getDestination());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getDisposition().length()!=0){
	        	tout.write(prop.getDisposition());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getDivision().length()!=0){
	        	tout.write(prop.getDivision());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getDocument_number().length()!=0){
	        	tout.write(prop.getDocument_number());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getEditor().length()!=0){
	        	tout.write(prop.getEditor());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getForward_to().length()!=0){
	        	tout.write(prop.getForward_to());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getGroup().length()!=0){
	        	tout.write(prop.getGroup());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getLanguage().length()!=0){
	        	tout.write(prop.getLanguage());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getMail_stop().length()!=0){
	        	tout.write(prop.getMail_stop());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getMatter().length()!=0){
	        	tout.write(prop.getMatter());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getOffice().length()!=0){
	        	tout.write(prop.getOffice());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getProject().length()!=0){
	        	tout.write(prop.getProject());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getPublisher().length()!=0){
	        	tout.write(prop.getPublisher());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getPurpose().length()!=0){
	        	tout.write(prop.getPurpose());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getReceived_from().length()!=0){
	        	tout.write(prop.getReceived_from());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getRecorded_by().length()!=0){
	        	tout.write(prop.getRecorded_by());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getRecorded_date().length()!=0){
	        	tout.write(prop.getRecorded_date());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getReference().length()!=0){
	        	tout.write(prop.getReference());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getRevision_date().length()!=0){
	        	tout.write(prop.getRevision_date());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getRevision_notes().length()!=0){
	        	tout.write(prop.getRevision_notes());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getSection().length()!=0){
	        	tout.write(prop.getSection());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getSecurity().length()!=0){
	        	tout.write(prop.getSecurity());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getSource().length()!=0){
	        	tout.write(prop.getSource());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getStatus().length()!=0){
	        	tout.write(prop.getStatus());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getTelephone_number().length()!=0){
	        	tout.write(prop.getTelephone_number());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getTypist().length()!=0){
	        	tout.write(prop.getTypist());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getVersion_date().length()!=0){
	        	tout.write(prop.getVersion_date());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getVersion_notes().length()!=0){
	        	tout.write(prop.getVersion_notes());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	     	if(prop.getVersion_number().length()!=0){
	        	tout.write(prop.getVersion_number());
	     	}
	     	else{
	     		tout.write(0);
	     	}
	     	
	        tout.flush();
            tout.close();
       }catch(IOException e){
       	    e.printStackTrace();
       		System.err.println("The System Error");
	        return 0;
       }
		return 1;
	}

	public static String delExtension(String filename) {
	    int i = filename.lastIndexOf('.');
	    if(i>0 && i<filename.length()-1) {
			return filename.substring(0,i);
	    }
	 	else{
	 		return filename;
	 	}
	}

	public static boolean TestGetTextV5(File app,DMCTextInfoV5 info,CMDInfo cinfo){
		File txt;
		int  iRet;
		if(app.isDirectory()){
				return false;
		}
		if(cinfo.GetsDstDir().length()==0){
			if(cinfo.GetbOU()==false){
				txt=new File(app.getParentFile(),delExtension(app.getName())+".txt");
			}
			else{
				if(cinfo.GetnFileCount()<=1){
					txt=new File(app.getParentFile(),cinfo.Gettxtfile());
				}
				else{
					txt=new File(app.getParentFile(),delExtension(app.getName())+".txt");
				}
			}
		}
		else{
			if(cinfo.GetbOU()==false){
				txt=new File(cinfo.GetsDstDir(),delExtension(app.getName())+".txt");
			}
			else{
				if(cinfo.GetnFileCount()<=1){
					txt=new File(cinfo.GetsDstDir(),cinfo.Gettxtfile());
				}
				else{
					txt=new File(cinfo.GetsDstDir(),delExtension(app.getName())+".txt");
				}
			}
		}

		try{
			DMCFileInfoV5 finfo=TextPorterV5.getDMCFileInfoV5(app, info);////////
			System.out.println("\nDetect file: "+app.getPath());
			System.out.println("DocFormat: "+'"'+finfo.getDocFormat()+'"');
			System.out.println("DocSubFormat: "+'"'+finfo.getDocSubFormat()+'"');
			System.out.println("DocCountry: "+'"'+finfo.getDocCountry()+'"');
			System.out.println("ProtectCode: "+finfo.getProtectCode());
			System.out.println("FileType: "+finfo.getFileType());
		}catch(DMCExceptionV5 e){ 
			System.err.println("\nDetect file"+app.getPath());
			System.err.println("DMC_GetFileInfoV5() return error "+e.getErrorReason());
			return false;
		}

		switch(cinfo.GetnFunc()){
			case CMDInfo.FT_GET_PAGE_TEXT_V5:
			case CMDInfo.FT_GET_PAGE_TEXT_V5W:
				try{
					if(cinfo.GetnFunc() == CMDInfo.FT_GET_PAGE_TEXT_V5){
						 TextPorterV5.getPageTextV5(app,txt,info,cinfo.Getpages());
					 }
					 else{
						 TextPorterV5.getPageTextV5W(app,txt,info,cinfo.Getpages());
					}
					if(cinfo.Getpages()!=0)
				 		System.out.println("\nGet page "+cinfo.Getpages()+" from "+app.getPath()+" to "+txt.getPath());
					 else
				 		System.out.println("\nGet total pages from "+app.getPath());
				}catch(DMCExceptionV5 e){ 
					System.err.println("\nGet page from "+app.getPath()+" to "+txt.getPath());
					System.err.println("DMC_GetPageText() return error "+e.getErrorReason());
				}
				break;
			case CMDInfo.FT_GET_PROPERTY_V5:
			case CMDInfo.FT_GET_PROPERTY_V5W:
				try{
					DMCPropertyV5 prop = new DMCPropertyV5();
					if(cinfo.GetnFunc() == CMDInfo.FT_GET_PROPERTY_V5){
						TextPorterV5.getPropertyV5(app,info,prop);
					}
					else{
						TextPorterV5.getPropertyV5W(app,info,prop);
					}
					iRet=WritePropToFile(prop,txt);
					if(iRet==1){
						System.out.println("\nGet property from "+app.getPath()+" to "+txt.getPath());
					}
					else if(iRet!=0){
						System.err.println("\nGet property from "+app.getPath()+" to "+txt.getPath());
						System.err.println("DMC_GetProperty() return error "+iRet);
					}
				}catch(DMCExceptionV5 e){ 
					System.err.println("\nGet property from "+app.getPath()+" to "+txt.getPath());
					System.err.println("DMC_GetProperty() return error "+e.getErrorReason());
				}
				break;
			case CMDInfo.FT_GET_PWD_TEXT_V5:
			case CMDInfo.FT_GET_PWD_TEXT_V5W:
				try{
					if(cinfo.GetnFunc() == CMDInfo.FT_GET_PWD_TEXT_V5){
						 TextPorterV5.getPwdTextV5(app,txt,info,cinfo.Getpassword());
					 }
					 else{
						 TextPorterV5.getPwdTextV5W(app,txt,info,cinfo.Getpassword());
					 }
					 System.out.println("\nGet text from "+app.getPath()+" to "+txt.getPath());
				}catch(DMCExceptionV5 e){ 
					System.err.println("\nGet text from "+app.getPath()+" to "+txt.getPath());
					System.err.println("Password: "+cinfo.Getpassword());
					System.err.println("DMC_GetTextV5() return error "+e.getErrorReason());

				}
				break;
			case CMDInfo.FT_GET_PWD_PAGE_TEXT_V5:
			case CMDInfo.FT_GET_PWD_PAGE_TEXT_V5W:
				try{
					if(cinfo.GetnFunc() == CMDInfo.FT_GET_PWD_PAGE_TEXT_V5){
						TextPorterV5.getPwdPageTextV5(app,txt,info,cinfo.Getpages(),cinfo.Getpassword());
					}
					else{
						TextPorterV5.getPwdPageTextV5W(app,txt,info,cinfo.Getpages(),cinfo.Getpassword());
					}
					if(cinfo.Getpages()!=0){
				 		System.out.println("\nGet page "+cinfo.Getpages()+" from "+app.getPath()+" to "+txt.getPath());
				 	}
					else{
						System.out.println("\nGet total pages from "+app.getPath());
					}
				}catch(DMCExceptionV5 e){ 
					System.err.println("\nGet page from "+app.getPath()+" to "+txt.getPath());
					System.err.println("Password: "+cinfo.Getpassword());
					System.err.println("DMC_GetPwdPageTextV5() return error "+e.getErrorReason());
				}
				break;
			case CMDInfo.FT_GET_PWD_PROPERTY_V5:
			case CMDInfo.FT_GET_PWD_PROPERTY_V5W:
				try{
					DMCPropertyV5 prop = new DMCPropertyV5();
					if(cinfo.GetnFunc() == CMDInfo.FT_GET_PWD_PROPERTY_V5){
						TextPorterV5.getPwdPropertyV5(app,info,prop,cinfo.Getpassword());
					}
					else{
						TextPorterV5.getPwdPropertyV5W(app,info,prop,cinfo.Getpassword());
					}
					iRet=WritePropToFile(prop,txt);
					if(iRet==1){
						System.out.println("\nGet property from "+app.getPath()+" to "+txt.getPath());
					}
					else if(iRet!=0){
						System.err.println("\nGet property from "+app.getPath()+" to "+txt.getPath());
						System.err.println("Password: "+cinfo.Getpassword());
						System.err.println("DMC_GetPropertyV5() return error "+iRet);
					}
				}catch(DMCExceptionV5 e){ 
					System.err.println("\nGet property from "+app.getPath()+" to "+txt.getPath());
					System.err.println("Password: "+cinfo.Getpassword());
					System.err.println("DMC_GetPropertyV5() return error "+e.getErrorReason());
				}
				break;
			case CMDInfo.FT_GET_TEXT_STREAM_V5:
			case CMDInfo.FT_GET_TEXT_STREAM_V5W:
				try{
					System.out.println("\nTest Stream interface");
					OutputStream writer = new FileOutputStream(txt);
					if(cinfo.GetnFunc() == CMDInfo.FT_GET_TEXT_STREAM_V5){
						TextPorterV5.getTextStreamV5(app,writer,info);
					}
					else{
						TextPorterV5.getTextStreamV5W(app,writer,info);
					}
					//TextPorterV5.getTextV5(app,System.out,info);
					System.out.println("\nGet textStreamV5 from "+app.getPath()+" to "+txt.getPath());
				}catch(DMCExceptionV5 e){ 
					System.err.println("\nGet textStreamV5 from "+app.getPath()+" to "+txt.getPath());
					System.err.println("DMC_GetTextStreamV5() return error "+e.getErrorReason());
				}
				catch(FileNotFoundException f) {
		       	    f.printStackTrace();
				}
				break;
			case CMDInfo.FT_GET_PAGE_TEXT_STREAM_V5:
			case CMDInfo.FT_GET_PAGE_TEXT_STREAM_V5W:
				try{
					System.out.println("\nTest Stream interface");
					OutputStream writer = new FileOutputStream(txt);
					if(cinfo.GetnFunc() == CMDInfo.FT_GET_PAGE_TEXT_STREAM_V5){
						TextPorterV5.getPageTextStreamV5(app,writer,info,cinfo.Getpages());
					}
					else{
						TextPorterV5.getPageTextStreamV5W(app,writer,info,cinfo.Getpages());
					}
					if(cinfo.Getpages()!=0)
				 		System.out.println("\nGet pageStreamV5 "+cinfo.Getpages()+" from "+app.getPath()+" to "+txt.getPath());
					else
				 		System.out.println("\nGet total pages from "+app.getPath());
				}catch(DMCExceptionV5 e){ 
					System.err.println("\nGet pageStreamV5 from "+app.getPath()+" to "+txt.getPath());
					System.err.println("DMC_GetPageTextStreamV5() return error "+e.getErrorReason());
				}
				catch(FileNotFoundException f) {
       	    		f.printStackTrace();
				}
				break;
			case CMDInfo.FT_GET_TEXT_V5:
			case CMDInfo.FT_GET_TEXT_V5W:
			default:
				try{
					if(cinfo.GetnFunc() == CMDInfo.FT_GET_TEXT_V5){
						TextPorterV5.getTextV5(app,txt,info);
					}
					else{
						TextPorterV5.getTextV5W(app,txt,info);
					}
					System.out.println("\nGet text from "+app.getPath()+" to "+txt.getPath());
				}catch(DMCExceptionV5 e){ 
					System.err.println("\nGet text from "+app.getPath()+" to "+txt.getPath());
					System.err.println("DMC_GetText() return error "+e.getErrorReason());

				}
				break;
			}			
			return true;
	}

	public static boolean TestGetTextV4(File app,DMCTextInfoV4 info,CMDInfo cinfo){
		File txt;
		int  iRet;
		if(app.isDirectory()){
				return false;
		}
		if(cinfo.GetsDstDir().length()==0){
			if(cinfo.GetbOU()==false){
				txt=new File(app.getParentFile(),delExtension(app.getName())+".txt");
			}
			else{
				if(cinfo.GetnFileCount()<=1){
					txt=new File(app.getParentFile(),cinfo.Gettxtfile());
				}
				else{
					txt=new File(app.getParentFile(),delExtension(app.getName())+".txt");
				}
			}
		}
		else{
			if(cinfo.GetbOU()==false){
				txt=new File(cinfo.GetsDstDir(),delExtension(app.getName())+".txt");
			}
			else{
				if(cinfo.GetnFileCount()<=1){
					txt=new File(cinfo.GetsDstDir(),cinfo.Gettxtfile());
				}
				else{
					txt=new File(cinfo.GetsDstDir(),delExtension(app.getName())+".txt");
				}
			}
		}

		try{
			DMCfileInfoV4 finfo=TextPorterV4.getDMCFileInfoV4(app);
			System.out.println("\nDetect file: "+app.getPath());
			System.out.println("DocFormat: "+'"'+finfo.getDocFormat()+'"');
			System.out.println("DocSubFormat: "+'"'+finfo.getDocSubFormat()+'"');
			System.out.println("DocCountry: "+'"'+finfo.getDocCountry()+'"');
			System.out.println("ProtectCode: "+finfo.getProtectCode());
			System.out.println("FileType: "+finfo.getFileType());
		}catch(DMCExceptionV4 e){ 
			System.err.println("\nDetect file"+app.getPath());
			System.err.println("DMC_GetFileInfoV4() return error "+e.getErrorReason());
			return false;
		}
		switch(cinfo.GetnFunc()){
			case CMDInfo.FT_GET_PAGE_TEXT_V4:
				try{
					TextPorterV4.getPageTextV4(app,txt,info,cinfo.Getpages());
					if(cinfo.Getpages()!=0)
				 		System.out.println("\nGet pageV4 "+cinfo.Getpages()+" from "+app.getPath()+" to "+txt.getPath());
					else
				 		System.out.println("\nGet total pages from "+app.getPath());
				}catch(DMCExceptionV4 e){ 
					System.err.println("\nGet pageV4 from "+app.getPath()+" to "+txt.getPath());
					System.err.println("DMC_GetPageTextV4() return error "+e.getErrorReason());
				}
				break;
			case CMDInfo.FT_GET_PROPERTY_V4:
				try{
					DMCPropertyV4 prop = new DMCPropertyV4();
					TextPorterV4.getPropertyV4(app,info,prop);
					iRet=WritePropToFile(prop,txt);
					if(iRet==1){
						System.out.println("\nGet propertyV4 from "+app.getPath()+" to "+txt.getPath());
					}
					else if(iRet!=0){
						System.err.println("\nGet propertyV4 from "+app.getPath()+" to "+txt.getPath());
						System.err.println("DMC_GetPropertyV4() return error "+iRet);
					}
				}catch(DMCExceptionV4 e){ 
					System.err.println("\nGet propertyV4 from "+app.getPath()+" to "+txt.getPath());
					System.err.println("DMC_GetPropertyV4() return error "+e.getErrorReason());
				}
				break;
			case CMDInfo.FT_GET_PWD_TEXT_V4:
				try{
					TextPorterV4.getPwdTextV4(app,txt,info,cinfo.Getpassword());
					System.out.println("\nGet PwdtextV4 from "+app.getPath()+" to "+txt.getPath());
				}catch(DMCExceptionV4 e){ 
					System.err.println("\nGet pWdtextV4 from "+app.getPath()+" to "+txt.getPath());
					System.err.println("Password: "+cinfo.Getpassword());
					System.err.println("DMC_GetPwdTextV4() return error "+e.getErrorReason());
				}
				break;
			case CMDInfo.FT_GET_PWD_PAGE_TEXT_V4:
				try{
					TextPorterV4.getPwdPageTextV4(app,txt,info,cinfo.Getpages(),cinfo.Getpassword());
					if(cinfo.Getpages()!=0)
						System.out.println("\nGet PwdpageV4 "+cinfo.Getpages()+" from "+app.getPath()+" to "+txt.getPath());
					 else
					 	System.out.println("\nGet total pages from "+app.getPath());
				}catch(DMCExceptionV4 e){ 
					System.err.println("\nGet PwdpageV4 from "+app.getPath()+" to "+txt.getPath());
					System.err.println("Password: "+cinfo.Getpassword());
					System.err.println("DMC_GetPwdPageTextV4() return error "+e.getErrorReason());
				}
				break;
			case CMDInfo.FT_GET_PWD_PROPERTY_V4:
				try{
					DMCPropertyV4 prop = new DMCPropertyV4();
					TextPorterV4.getPwdPropertyV4(app,info,prop,cinfo.Getpassword());
					iRet=WritePropToFile(prop,txt);
					if(iRet==1){
						System.out.println("\nGet propertyV4 from "+app.getPath()+" to "+txt.getPath());
					}
					else if(iRet!=0){
						System.err.println("\nGet propertyV4 from "+app.getPath()+" to "+txt.getPath());
						System.err.println("Password: "+cinfo.Getpassword());
						System.err.println("DMC_GetPropertyV4() return error "+iRet);
					}
				}catch(DMCExceptionV4 e){ 
					System.err.println("\nGet propertyV4 from "+app.getPath()+" to "+txt.getPath());
					System.err.println("Password: "+cinfo.Getpassword());
					System.err.println("DMC_GetPropertyV4() return error "+e.getErrorReason());
				}
				break;
			case CMDInfo.FT_GET_TEXT_STREAM_V4:
				try{
					System.out.println("\nTest Stream interface");
					OutputStream writer = new FileOutputStream(txt);
					TextPorterV4.getTextStreamV4(app,writer,info);
					//TextPorterV4.getTextV4(app,System.out,info);
					System.out.println("\nGet textStreamV4 from "+app.getPath()+" to "+txt.getPath());
				}catch(DMCExceptionV4 e){ 
					System.err.println("\nGet textStreamV4 from "+app.getPath()+" to "+txt.getPath());
					System.err.println("DMC_GetTextStreamV4() return error "+e.getErrorReason());
				}
				catch(FileNotFoundException f) {}
				break;
			case CMDInfo.FT_GET_PAGE_TEXT_STREAM_V4:
				try{
					System.out.println("\nTest Stream interface");
					OutputStream writer = new FileOutputStream(txt);
					TextPorterV4.getPageTextStreamV4(app,writer,info,cinfo.Getpages());
					if(cinfo.Getpages()!=0)
				 		System.out.println("\nGet pageStreamV4 "+cinfo.Getpages()+" from "+app.getPath()+" to "+txt.getPath());
					else
				 		System.out.println("\nGet total pages from "+app.getPath());
				}catch(DMCExceptionV4 e){ 
					System.err.println("\nGet pageStreamV4 from "+app.getPath()+" to "+txt.getPath());
					System.err.println("DMC_GetPageTextStreamV4() return error "+e.getErrorReason());
				}
				catch(FileNotFoundException f) {}
				break;
			case CMDInfo.FT_GET_TEXT_V4:
			default:
				try{
					TextPorterV4.getTextV4(app,txt,info);
					System.out.println("\nGet textV4 from "+app.getPath()+" to "+txt.getPath());
				}catch(DMCExceptionV4 e){ 
					System.err.println("\nGet textV4 from "+app.getPath()+" to "+txt.getPath());
					System.err.println("DMC_GetTextV4() return error "+e.getErrorReason());
				}
				break;
			}
			return true;
	}


	public static void main(String[] args){
		CMDInfo cinfo=new CMDInfo();

		if(!ParseCmdLine(args,cinfo)){
			WriteUsage();
		}
		if(cinfo.GetnFunc() >= CMDInfo.FT_GET_TEXT_V5 && 
				cinfo.GetnFunc() <= CMDInfo.FT_GET_PAGE_TEXT_STREAM_V5 ||
		   cinfo.GetnFunc() >= CMDInfo.FT_GET_TEXT_V5W && 
				cinfo.GetnFunc() <= CMDInfo.FT_GET_PAGE_TEXT_STREAM_V5W){
			DMCTextInfoV5 info=new DMCTextInfoV5();
			GetTextInfoV5(info,cinfo);

			for(int i=0;i<cinfo.GetnFileCount();i++){
				File app=new File(args[cinfo.GetnFilePos()+i]);
				if(!app.exists()){
					System.err.println("File not Found "+args[i]);
					continue;
				}
				TestGetTextV5(app,info,cinfo);
			}
		}
		else { // V4 fuctions
			DMCTextInfoV4 info=new DMCTextInfoV4();
			GetTextInfoV4(info,cinfo);

			for(int i=0;i<cinfo.GetnFileCount();i++){
				File app=new File(args[cinfo.GetnFilePos()+i]);
				if(!app.exists()){
					System.err.println("File not Found "+args[i]);
					continue;
				}
				TestGetTextV4(app,info,cinfo);
			}
		}
	}
}
