﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
using DMC;

namespace sample {
	class Program {
		static void Main(string[] args) {
			if (args.Length < 2) {
				Console.Out.WriteLine("usage: sample appFile txtFile");
				return;
			}
			var textInfo = new DMC.TextInfoV5();
			textInfo.DefLangName = DMC.TextInfoV5.JAPANESE;
			var fileInfo = new DMC.FileInfo();
			var result = DMC.TextPorterV5.GetFileInfo_V5W(args[0], fileInfo, textInfo);
			Console.Out.WriteLine(result);
			Console.Out.WriteLine(fileInfo.DocFormat);
			//
			textInfo.GroupName = DMC.TextInfoV5.UTF8;
			textInfo.Option = DMC.TextInfoV5.DMC_GETTEXT_OPT_OLE | DMC.TextInfoV5.DMC_GETTEXT_OPT_OLE2 | DMC.TextInfoV5.DMC_GETTEXT_OPT_OLE3;
			result = DMC.TextPorterV5.GetText_V5W(args[0], args[1], textInfo);
			System.Console.Out.WriteLine(result);
		}
	}
}
