#!/bin/sh

if test "$1" = "d"; then
	shift;
	BUILDMODE=Debug
else
	BUILDMODE=Release
fi

if ! test -d $BUILDMODE; then
	mkdir $BUILDMODE
fi

if ! test -d dmcdotnetif/$BUILDMODE; then
	mkdir dmcdotnetif/$BUILDMODE
fi

echo g++ $BUILDMODE
if [ $BUILDMODE = Debug ]; then
	g++ -v -c -D_REENTRANT -fPIC -g -D_DEBUG -o dmcdotnetif/$BUILDMODE/dmcdotnetif.o dmcdotnetif/dmcdotnetif.cpp
else
	g++ -v -c -D_REENTRANT -fPIC -O3 -o dmcdotnetif/$BUILDMODE/dmcdotnetif.o dmcdotnetif/dmcdotnetif.cpp
fi
g++ -shared -Wl,-soname,libdmcdotnetif.so.5 -L dmcdotnetif/Lib dmcdotnetif/$BUILDMODE/dmcdotnetif.o -l dmc_txif -o $BUILDMODE/libdmcdotnetif.so.5.5

cd dmcdotnet
dotnet build -c $BUILDMODE
cd ..
cd sample
dotnet build -c $BUILDMODE
cd ..
cp dmcdotnet/bin/$BUILDMODE/net5.0/dmcdotnet.dll $BUILDMODE
cp sample/bin/$BUILDMODE/net5.0/sample.dll $BUILDMODE
cp sample/bin/$BUILDMODE/net5.0/sample.runtimeconfig.json $BUILDMODE
cd $BUILDMODE
rm libdmcdotnetif.so.5
ln -s libdmcdotnetif.so.5.5 libdmcdotnetif.so.5
rm libdmcdotnetif.so
ln -s libdmcdotnetif.so.5 libdmcdotnetif.so
cd ..
