//
//	Word API .NET Interface sample program
//
//	Microsoft Word のdocx文書ファイルの
//　本文の段落へコメントと脚注を追加する例です。
//
//	Copyright (c) 2020-2023 Antenna House, Inc. All rights reserved.
//

using AHOOXMLDocxManager;

public class CommentFootNoteEdit
{
    static void Main()
    {
        try
        {
            var inputFilePath = @".\paragraph-edit.docx";
            var outputFilePath = @".\result\paragraph_comment_footnote-edit.docx";
            
            using var ahWord = new AHWordprocessingDocument(inputFilePath);
            
            var ahDocument = ahWord.AHDocument;
            // 本文領域の1段目の文字列"文書ファイル"へコメントを追加
            {
            	var ahParagraph = ahDocument.GetParagraph(1);
                var ahComment = ahParagraph.AddComment("対応形式は docx", "アンテナ太郎", "文書ファイル");
            }
            // 本文領域の2段目に脚注を追加
            {
            	var ahParagraph = ahDocument.GetParagraph(2);
            	var ahFootnote = ahParagraph.AddFootnote("逐次編集処理は .NET インターフェイスのみで有効です。");
            }
            
            ahWord.Save(outputFilePath);
            System.Console.WriteLine("CommentFootNoteEdit: Processing completed normally.");
        }
        catch (AHOOXMLDocxManagerException ahException)
        {
            System.Console.WriteLine("ErrorCode: " + ahException.ErrorCode);
            System.Console.WriteLine("ErrorMessage: " + ahException.ErrorMessage);
        }
    }
}