//
//	Word API .NET Interface sample program
//
//	Microsoft Word で作成したdocx文書ファイルの
//　本文から内容と段落番号を取得する例です。
//
//	Copyright (c) 2020-2023 Antenna House, Inc. All rights reserved.
//

using AHOOXMLDocxManager;

public class ParagraphConfirm
{
    static void Main()
    {
        var inputFilePath = @".\paragraph-edit.docx";
    	
    	using var ahWord = new AHWordprocessingDocument(inputFilePath);
    	
        var ahDocument = ahWord.AHDocument;
        IAHParagraph? prevParagraph = null;
        for (int i = 1; ; ++i)
        {
            var paragraph = ahDocument.GetParagraph(i);
            if (prevParagraph == paragraph || paragraph == null) break;
            System.Console.WriteLine(paragraph.GetParagraphText() + "<- Paragraph(" + i + ")");
            prevParagraph = paragraph;
        }
    }
}
