//
//	Word API .NET Interface sample program
//
//	Microsoft Word で作成した白紙のdocx文書ファイルに
//　ヘッダー・フッターと段落を追加する例です。
//
//	Copyright (c) 2020-2023 Antenna House, Inc. All rights reserved.
//

using AHOOXMLDocxManager;

public class ParagraphEdit
{
    static void Main()
    {
        try
        {
            var inputFilePath = @".\blank.docx";
            var outputFilePath = @".\result\paragraph-edit.docx";
            
            using var ahWord = new AHWordprocessingDocument(inputFilePath);
            
            var ahDocument = ahWord.AHDocument;
            // ヘッダー領域へ段落追加
            {
            	var ahSection = ahDocument.GetAHSection(1);
            	var ahHeader = ahSection.AddHeader(AHHeaderFooterType.OddPages);
            	var headerParagraph = ahHeader.AddParagraph();
            	headerParagraph.AppendText("Word API 逐次編集処理サンプル");
            }
            // フッター領域へ段落追加
            {
            	var ahSection = ahDocument.GetAHSection(1);
            	var ahFooter = ahSection.AddFooter(AHHeaderFooterType.OddPages);
            	var footerParagraph = ahFooter.AddParagraph();
            	footerParagraph.AppendText("Antenna House, Inc.");
            }
            // 本文領域の1段目に段落を追加
            {
                var ahParagraph = ahDocument.GetParagraph(1);
                ahParagraph.AppendText("Word API は、Microsoft Wordの文書ファイルの加工・処理を行うライブラリです。");
            }
            // 本文領域の2段目（最終行）に段落を追加
            {
                var ahParagraph = ahDocument.AddParagraph();
                ahParagraph.AppendText("逐次編集処理で段落の取得や追加を行えます。");
            }
            
            ahWord.Save(outputFilePath);
            System.Console.WriteLine("ParagraphEdit: Processing completed normally.");
        }
        catch (AHOOXMLDocxManagerException ahException)
        {
            System.Console.WriteLine("ErrorCode: " + ahException.ErrorCode);
            System.Console.WriteLine("ErrorMessage: " + ahException.ErrorMessage);
        }
    }
}