//
//	Word API .NET Interface sample program
//
//	Microsoft Word で作成したdocx文書ファイルの
//　プロパティ情報を編集する例です。
//
//	Copyright (c) 2020-2023 Antenna House, Inc. All rights reserved.
//

using AHOOXMLDocxManager;

public class PropinfosEdit
{
    static void Main()
    {
        try
        {
            var inputFilePath = @".\propinfos-base.docx";
            var outputFilePath = @".\result\propinfos-edit.docx";
            
            using var ahWord = new AHWordprocessingDocument(inputFilePath);
            
            // プロパティ情報の編集
            var ahCore = ahWord.AHCore;
            ahCore.SetTitle("逐次編集処理サンプル");
            ahCore.AddKeyWords("Word API");
            ahCore.CleanCategory();
            ahCore.SetDescription("プロパティ情報の編集");
            
            var ahApp = ahWord.AHApp;
            ahApp.SetCompany("アンテナハウス");
            
            ahWord.Save(outputFilePath);
            System.Console.WriteLine("PropinfosEdit: Processing completed normally.");
        }
        catch (AHOOXMLDocxManagerException ahException)
        {
            System.Console.WriteLine("ErrorCode: " + ahException.ErrorCode);
            System.Console.WriteLine("ErrorMessage: " + ahException.ErrorMessage);
        }
    }
}